/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.jubula.autagent.gui.utils.AgentOMKeyProperitesUtils;
import org.eclipse.jubula.autagent.i18n.Messages;
import org.eclipse.jubula.client.core.constants.InputCodeHelper;

public class ObjectMappingSettingsFrame
extends JFrame {
    public ObjectMappingSettingsFrame() {
        AgentOMKeyProperitesUtils.loadPropertiesFromFile();
        this.setTitle(Messages.OMSettingsTitle);
        this.setResizable(false);
        ObjectMappingSettingsFrame frame = this;
        this.setSize(300, 150);
        this.createContent(frame);
    }

    private void createContent(final JFrame frame) {
        final InputCodeHelper inputCodeHelper = InputCodeHelper.getInstance();
        int modifierIndex = inputCodeHelper.getIndexOfModifier(AgentOMKeyProperitesUtils.getModifier());
        int inputIndex = this.getInputIndex(inputCodeHelper);
        JPanel panel = new JPanel();
        GridBagLayout bagLayout = new GridBagLayout();
        GridBagConstraints constraints = this.createDefaultConstraints();
        JTextArea label = new JTextArea(Messages.OMSettingsText);
        label.setWrapStyleWord(true);
        label.setLineWrap(true);
        label.setEditable(false);
        label.setFocusable(false);
        label.setBackground(UIManager.getColor("Label.background"));
        label.setFont(UIManager.getFont("Label.font"));
        label.setBorder(UIManager.getBorder("Label.border"));
        panel.setLayout(bagLayout);
        String[] keyStrings = inputCodeHelper.getModifierString();
        final JComboBox<String> modifier = new JComboBox<String>(keyStrings);
        modifier.setSelectedIndex(modifierIndex);
        String[] inPutStrings = inputCodeHelper.getInputStrings();
        JLabel plus = new JLabel("+");
        final JComboBox<String> inputs = new JComboBox<String>(inPutStrings);
        inputs.setSelectedIndex(inputIndex);
        JButton closeButton = new JButton(Messages.OMSettingsClose);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        JButton saveButton = new JButton(Messages.OMSettingsSave);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modifierValue = inputCodeHelper.getModifier()[modifier.getSelectedIndex()];
                InputCodeHelper.UserInput inputUserInput = inputCodeHelper.getInputs()[inputs.getSelectedIndex()];
                AgentOMKeyProperitesUtils.setModifier(modifierValue);
                AgentOMKeyProperitesUtils.setInput(inputUserInput);
                AgentOMKeyProperitesUtils.writePropertiesToFile();
                frame.dispose();
            }
        });
        constraints.fill = 2;
        constraints.gridwidth = 3;
        panel.add((Component)label, constraints);
        constraints.gridwidth = 1;
        constraints.gridy = 1;
        panel.add(modifier, constraints);
        constraints.gridx = 1;
        panel.add((Component)plus, constraints);
        constraints.gridx = 2;
        panel.add(inputs, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        panel.add((Component)saveButton, constraints);
        constraints.gridx = 2;
        constraints.anchor = 13;
        panel.add((Component)closeButton, constraints);
        frame.add(panel);
    }

    private int getInputIndex(InputCodeHelper inputCodeHelper) {
        InputCodeHelper.UserInput input = AgentOMKeyProperitesUtils.getInput();
        InputCodeHelper.UserInput[] inputKeys = inputCodeHelper.getInputs();
        int inputIndex = 0;
        int i = 0;
        while (i < inputKeys.length) {
            InputCodeHelper.UserInput arrayelement = inputKeys[i];
            if (arrayelement.equals((Object)input)) {
                inputIndex = i;
                break;
            }
            ++i;
        }
        return inputIndex;
    }

    private GridBagConstraints createDefaultConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 10, 10, 10);
        constraints.anchor = 17;
        return constraints;
    }
}

