/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.internal.launch.LaunchingUtils;
import org.eclipse.m2e.internal.launch.MavenLaunchExtensionsSupport;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;
import org.eclipse.m2e.internal.launch.MavenRuntimeLaunchSupport;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchDelegate
extends JavaLaunchDelegate
implements MavenLaunchConstants {
    static final Logger log;
    private static final String LAUNCHER_TYPE = "org.codehaus.classworlds.Launcher";
    private static final String LAUNCHER_TYPE3 = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final VersionRange MAVEN_33PLUS_RUNTIMES;
    private ILaunch launch;
    private IProgressMonitor monitor;
    private String programArguments;
    private MavenRuntimeLaunchSupport launchSupport;
    private MavenLaunchExtensionsSupport extensionsSupport;

    static {
        VersionRange mvn33PlusRange;
        log = LoggerFactory.getLogger(MavenLaunchDelegate.class);
        try {
            mvn33PlusRange = VersionRange.createFromVersionSpec((String)"[3.3,)");
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
            mvn33PlusRange = null;
        }
        MAVEN_33PLUS_RUNTIMES = mvn33PlusRange;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.monitor = monitor;
        this.programArguments = null;
        try {
            this.launchSupport = MavenRuntimeLaunchSupport.create(configuration, launch, monitor);
            this.extensionsSupport = MavenLaunchExtensionsSupport.create(configuration, launch);
            log.info("" + this.getWorkingDirectory(configuration));
            log.info(" mvn" + this.getProgramArguments(configuration));
            this.extensionsSupport.configureSourceLookup(configuration, launch, monitor);
            super.launch(configuration, mode, launch, monitor);
        }
        finally {
            this.launch = null;
            this.monitor = null;
            this.launchSupport = null;
            this.extensionsSupport = null;
        }
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.launchSupport.decorateVMRunner(super.getVMRunner(configuration, mode));
    }

    public String getMainTypeName(ILaunchConfiguration configuration) {
        return this.launchSupport.getVersion().startsWith("3.") ? LAUNCHER_TYPE3 : LAUNCHER_TYPE;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) {
        List<String> cp = this.launchSupport.getBootClasspath();
        return cp.toArray(new String[cp.size()]);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        if (this.programArguments == null) {
            String goals = this.getGoals(configuration);
            StringBuilder sb = new StringBuilder();
            this.getProperties(sb, configuration);
            this.getPreferences(sb, configuration, goals);
            sb.append(" ").append(goals);
            this.extensionsSupport.appendProgramArguments(sb, configuration, this.launch, this.monitor);
            this.programArguments = sb.toString();
        }
        return this.programArguments;
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        MavenRuntimeLaunchSupport.VMArguments arguments = this.launchSupport.getVMArguments();
        AbstractMavenRuntime runtime = MavenLaunchUtils.getMavenRuntime(configuration);
        this.appendRuntimeSpecificArguments(runtime.getVersion(), arguments, configuration);
        this.extensionsSupport.appendVMArguments(arguments, configuration, this.launch, this.monitor);
        arguments.append(super.getVMArguments(configuration));
        return arguments.toString();
    }

    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("M2_GOALS", "");
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        return false;
    }

    private void getProperties(StringBuilder sb, ILaunchConfiguration configuration) throws CoreException {
        try {
            List properties = configuration.getAttribute("M2_PROPERTIES", Collections.EMPTY_LIST);
            for (String property : properties) {
                int n = property.indexOf(61);
                String name = property;
                String value = null;
                if (n > -1) {
                    name = property.substring(0, n);
                    if (n > 1) {
                        value = LaunchingUtils.substituteVar(property.substring(n + 1));
                    }
                }
                sb.append(" -D").append(name);
                if (value == null) continue;
                sb.append('=').append(MavenLaunchUtils.quote(value));
            }
        }
        catch (CoreException e) {
            String msg = "Exception while getting configuration attribute M2_PROPERTIES";
            log.error(msg, (Throwable)e);
            throw e;
        }
        try {
            String profiles = configuration.getAttribute("M2_PROFILES", null);
            if (profiles != null && profiles.trim().length() > 0) {
                sb.append(" -P").append(profiles.replaceAll("\\s+", ","));
            }
        }
        catch (CoreException ex) {
            String msg = "Exception while getting configuration attribute M2_PROFILES";
            log.error(msg, (Throwable)ex);
            throw ex;
        }
    }

    private void getPreferences(StringBuilder sb, ILaunchConfiguration configuration, String goals) throws CoreException {
        int threads;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        sb.append(" -B");
        if (configuration.getAttribute("M2_DEBUG_OUTPUT", mavenConfiguration.isDebugOutput())) {
            sb.append(" -X").append(" -e");
        }
        if (configuration.getAttribute("M2_OFFLINE", mavenConfiguration.isOffline())) {
            sb.append(" -o");
        }
        if (configuration.getAttribute("M2_UPDATE_SNAPSHOTS", false)) {
            sb.append(" -U");
        }
        if (configuration.getAttribute("M2_NON_RECURSIVE", false)) {
            sb.append(" -N");
        }
        if (configuration.getAttribute("M2_SKIP_TESTS", false)) {
            sb.append(" -Dmaven.test.skip=true -DskipTests");
        }
        if ((threads = configuration.getAttribute("M2_THREADS", 1)) > 1) {
            sb.append(" --threads ").append(threads);
        }
        if (!goals.contains("-gs ")) {
            String globalSettings = this.launchSupport.getSettings();
            if (globalSettings != null && !globalSettings.trim().isEmpty() && !new File(globalSettings.trim()).exists()) {
                globalSettings = null;
            }
            if (globalSettings != null && !globalSettings.trim().isEmpty()) {
                sb.append(" -gs ").append(MavenLaunchUtils.quote(globalSettings));
            }
        }
        String settings = configuration.getAttribute("M2_USER_SETTINGS", null);
        if (!((settings = LaunchingUtils.substituteVar(settings)) != null && !settings.trim().isEmpty() || (settings = mavenConfiguration.getUserSettingsFile()) == null || settings.trim().isEmpty() || new File(settings.trim()).exists())) {
            settings = null;
        }
        if (settings != null && !settings.trim().isEmpty()) {
            sb.append(" -s ").append(MavenLaunchUtils.quote(settings));
        }
    }

    public void appendRuntimeSpecificArguments(String runtimeVersion, MavenRuntimeLaunchSupport.VMArguments arguments, ILaunchConfiguration configuration) throws CoreException {
        if (this.applies(runtimeVersion)) {
            this.getArgsFromMvnDir(arguments, configuration);
        }
    }

    private void getArgsFromMvnDir(MavenRuntimeLaunchSupport.VMArguments arguments, ILaunchConfiguration configuration) throws CoreException {
        String pomDir = LaunchingUtils.substituteVar(configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, ""));
        if (pomDir.isEmpty()) {
            return;
        }
        File baseDir = this.findMavenProjectBasedir(new File(pomDir));
        File mvnDir = new File(baseDir, ".mvn");
        File jvmConfig = new File(mvnDir, "jvm.config");
        if (jvmConfig.isFile()) {
            try {
                for (String line : Files.readLines((File)jvmConfig, (Charset)Charsets.UTF_8)) {
                    arguments.append(line);
                }
            }
            catch (IOException ex) {
                Status error = new Status(4, "org.eclipse.m2e.core", NLS.bind((String)Messages.MavenLaunchDelegate_error_cannot_read_jvmConfig, (Object)jvmConfig.getAbsolutePath()), (Throwable)ex);
                throw new CoreException((IStatus)error);
            }
        }
        arguments.appendProperty("maven.multiModuleProjectDirectory", MavenLaunchUtils.quote(baseDir.getAbsolutePath()));
    }

    private File findMavenProjectBasedir(File dir) {
        File folder = dir;
        while (folder != null && folder.getParentFile() != null) {
            if (new File(folder, ".mvn").isDirectory()) {
                return folder;
            }
            folder = folder.getParentFile();
        }
        return dir;
    }

    private boolean applies(String runtimeVersion) {
        return MAVEN_33PLUS_RUNTIMES.containsVersion((ArtifactVersion)new DefaultArtifactVersion(runtimeVersion));
    }
}

