/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskListModifyOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class ChangeActivityHandleOperation
extends TaskListModifyOperation {
    private final Map<String, String> handles;

    public ChangeActivityHandleOperation(String oldHandle, String newHandle) {
        this(Collections.singletonMap(oldHandle, newHandle));
    }

    public ChangeActivityHandleOperation(Map<String, String> handles) {
        this.handles = handles;
    }

    protected void operations(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Map<String, String> changedHandles = this.handles.entrySet().stream().filter(e -> !e.getKey().equals(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (changedHandles.isEmpty()) {
            return;
        }
        try {
            this.refactorMetaContextHandles(changedHandles, monitor);
            TasksUiPlugin.getTaskActivityMonitor().reloadActivityTime();
        }
        finally {
            monitor.done();
        }
    }

    private void refactorMetaContextHandles(Map<String, String> oldToNewHandles, IProgressMonitor monitor) {
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        ContextCorePlugin.getContextManager().resetActivityMetaContext();
        InteractionContext newMetaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        List interactionHistory = metaContext.getInteractionHistory();
        monitor.beginTask(Messages.ChangeActivityHandleOperation_Activity_migration, interactionHistory.size());
        for (InteractionEvent event : interactionHistory) {
            String newHandle;
            if (event.getStructureHandle() != null && (newHandle = oldToNewHandles.get(event.getStructureHandle())) != null) {
                event = new InteractionEvent(event.getKind(), event.getStructureKind(), newHandle, event.getOriginId(), event.getNavigation(), event.getDelta(), event.getInterestContribution(), event.getDate(), event.getEndDate());
            }
            newMetaContext.parseEvent(event);
            monitor.worked(1);
        }
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
    }
}

