/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.ant.tasks;

import com.google.common.base.Joiner;
import java.io.File;
import java.text.MessageFormat;
import org.junit.Assert;

class WikiPageAssertions {
    private static final int MINIMUM_EXPECTED_IMAGES_EXCLUSIVE = 10;

    public static void assertManyImages(File imagesFolder) {
        Assert.assertTrue((String)imagesFolder.getPath(), (imagesFolder.exists() && imagesFolder.isDirectory() ? 1 : 0) != 0);
        Object[] images = imagesFolder.listFiles();
        Assert.assertNotNull((String)MessageFormat.format("{0} should have files", imagesFolder), (Object)images);
        int imageCount = WikiPageAssertions.imageCount((File[])images);
        Assert.assertTrue((String)MessageFormat.format("Expected at least {0} images but got {1} (files in path: {2})", 10, imageCount, Joiner.on((String)", ").join(images)), (imageCount > 10 ? 1 : 0) != 0);
    }

    private static int imageCount(File[] images) {
        int count = 0;
        File[] fileArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (name.endsWith(".png") || name.endsWith(".gif") || name.endsWith(".jpeg") || name.endsWith(".jpg")) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private WikiPageAssertions() {
    }
}

