/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.ant.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.tools.ant.Project;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.ant.tasks.WikiPageAssertions;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.ant.tasks.WikiToDocTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class WikiToDocTaskIntegrationTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private WikiToDocTask task;

    @Before
    public void before() throws IOException {
        this.task = new WikiToDocTask();
        this.task.setDest(this.temporaryFolder.getRoot());
        this.task.setProject(new Project());
    }

    @Test
    public void processPageWithManyImages() {
        this.task.setWikiBaseUrl("https://wiki.eclipse.org");
        this.task.setPrependImagePrefix("images");
        this.task.setFormatOutput(true);
        this.task.setGenerateUnifiedToc(false);
        WikiToDocTask.Path path = new WikiToDocTask.Path();
        path.setTitle("Linux Tools Project - User Guide");
        String wikiPageName = "Linux_Tools_Project/Vagrant_Tooling/User_Guide";
        path.setName(wikiPageName);
        path.setGenerateToc(true);
        this.task.setPaths(Collections.singletonList(path));
        this.task.execute();
        File wikiPageFolder = new File(this.temporaryFolder.getRoot(), wikiPageName);
        this.assertManyImages(wikiPageFolder);
    }

    private void assertManyImages(File wikiPageFolder) {
        Assert.assertTrue((boolean)wikiPageFolder.exists());
        File imagesFolder = new File(wikiPageFolder, "images");
        WikiPageAssertions.assertManyImages(imagesFolder);
    }
}

