/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.textile.core.TextileDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class TextileDocumentBuilderTest
extends TestCase {
    private static final String[] PLATFORM_NEWLINES = new String[]{"\r\n", "\r", "\n"};
    private TextileDocumentBuilder builder;
    private StringWriter out;

    protected void setUp() throws Exception {
        this.out = new StringWriter();
        this.builder = new TextileDocumentBuilder((Writer)this.out);
        super.setUp();
    }

    public void testParagraph_MultipleNewlinesInParagraph() throws Exception {
        String[] stringArray = PLATFORM_NEWLINES;
        int n = PLATFORM_NEWLINES.length;
        int n2 = 0;
        while (n2 < n) {
            String newline = stringArray[n2];
            this.setUp();
            this.builder.beginDocument();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            this.builder.characters("text" + newline + newline + "more text");
            this.builder.endBlock();
            this.builder.endDocument();
            String markup = this.out.toString();
            TestUtil.println(markup);
            TextileDocumentBuilderTest.assertEquals((String)"text more text\n\n", (String)markup);
            ++n2;
        }
    }

    public void testParagraph_MultipleNewlinesInImplicitParagraph() throws Exception {
        String[] stringArray = PLATFORM_NEWLINES;
        int n = PLATFORM_NEWLINES.length;
        int n2 = 0;
        while (n2 < n) {
            String newline = stringArray[n2];
            this.setUp();
            this.builder.beginDocument();
            this.builder.characters("a" + newline + newline + "b");
            this.builder.endDocument();
            String markup = this.out.toString();
            TestUtil.println(markup);
            TextileDocumentBuilderTest.assertEquals((String)"a b\n\n", (String)markup);
            ++n2;
        }
    }

    public void testParagraph_MultipleLineBreaksInParagraph() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("more text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"text\nmore text\n\n", (String)markup);
    }

    public void testParagraph_MultipleLineBreaksInImplicitParagraph() {
        this.builder.beginDocument();
        this.builder.characters("text");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("more text");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"text\nmore text\n\n", (String)markup);
    }

    public void testParagraph_NewlineFollowedBySpaceOrTabInParagraph() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.lineBreak();
        this.builder.characters(" more");
        this.builder.lineBreak();
        this.builder.characters("\tmore2 text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"text\n more\n\tmore2 text\n\n", (String)markup);
    }

    public void testMultipleParagraphs() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("first paragraph");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("second paragraph");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"first paragraph\n\nsecond paragraph\n\n", (String)markup);
    }

    public void testParagraphWithBoldEmphasis() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("some ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("bold");
        this.builder.endSpan();
        this.builder.characters(" and ");
        this.builder.beginSpan(DocumentBuilder.SpanType.EMPHASIS, new Attributes());
        this.builder.characters("emphasis");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"some **bold** and _emphasis_\n\n", (String)markup);
    }

    public void testParagraphWithCssClass() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes(null, "test", null, null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"p(test). text more text\n\n", (String)markup);
    }

    public void testParagraphWithCssStyle() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes(null, null, "x-test: foo;", null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"p{x-test: foo;}. text more text\n\n", (String)markup);
    }

    public void testParagraphWithId() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes("123", null, null, null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"p(#123). text more text\n\n", (String)markup);
    }

    public void testParagraphWithIdAndClass() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes("123", "test", null, null));
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"p(test#123). text more text\n\n", (String)markup);
    }

    public void testParagraphWithLink() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text\n\nmore text ");
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("http://example.com/foo+bar/baz.gif");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.characters("baz");
        this.builder.endSpan();
        this.builder.characters(" test");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"text more text \"baz\":http://example.com/foo+bar/baz.gif test\n\n", (String)markup);
    }

    public void testBlockCode() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"bc.. text\n\nmore text\n\n", (String)markup);
    }

    public void testParagraphFollowingExtendedBlockCode() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("text\n\nmore text");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text2");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"bc.. text\n\nmore text\n\np. text\n\ntext2\n\n", (String)markup);
    }

    public void testHeading1() {
        this.builder.beginDocument();
        this.builder.beginHeading(1, new Attributes());
        this.builder.characters("text\n\nmore text");
        this.builder.endHeading();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"h1. text more text\n\ntext\n\n", (String)markup);
    }

    public void testHeading1_WithNestedMarkup() {
        this.builder.beginDocument();
        this.builder.beginHeading(1, new Attributes());
        this.builder.characters("text ");
        this.builder.beginSpan(DocumentBuilder.SpanType.EMPHASIS, new Attributes());
        this.builder.characters("emphasized");
        this.builder.endSpan();
        this.builder.endHeading();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"h1. text _emphasized_\n\ntext\n\n", (String)markup);
    }

    public void testHeading1_WithAttributes() {
        String markup = this.doHeadingAttributesTest();
        TextileDocumentBuilderTest.assertEquals((String)"h1(classTest#idTest). text more text\n\n", (String)markup);
    }

    public void testHeading1_WithoutAttributes() {
        this.builder.setEmitAttributes(false);
        String markup = this.doHeadingAttributesTest();
        TextileDocumentBuilderTest.assertEquals((String)"h1. text more text\n\n", (String)markup);
    }

    private String doHeadingAttributesTest() {
        this.builder.beginDocument();
        Attributes headingAttributes = new Attributes();
        headingAttributes.setCssClass("classTest");
        headingAttributes.setId("idTest");
        this.builder.beginHeading(1, headingAttributes);
        this.builder.characters("text\n\nmore text");
        this.builder.endHeading();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        return markup;
    }

    public void testImplicitParagrah() {
        this.builder.beginDocument();
        this.builder.characters("text1");
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text2");
        this.builder.endBlock();
        this.builder.characters("text3");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"text1\n\ntext2\n\ntext3\n\n", (String)markup);
    }

    public void testImplicitParagrahWithSpan() {
        this.builder.beginDocument();
        this.builder.beginSpan(DocumentBuilder.SpanType.STRONG, new Attributes());
        this.builder.characters("text1");
        this.builder.endSpan();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text2");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"*text1*\n\ntext2\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_spanAtLineStart() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.STRONG, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.characters("text3");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"*text2* text3\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_spanAtLineEnd() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text3");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"text3 **text2**\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_spanMidLine() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("text3");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.characters("text4");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"text3 **text2** text4\n\n", (String)markup);
    }

    public void testBoldSpanNoWhitespace_adjacentSpans() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.beginSpan(DocumentBuilder.SpanType.ITALIC, new Attributes());
        this.builder.characters("text3");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"**text2** __text3__\n\n", (String)markup);
    }

    public void testBoldSpanWithAdjacentPunctuation() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.characters("!");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"**text2**!\n\n", (String)markup);
    }

    public void testBulletedList() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("text2");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text3");
        this.builder.endSpan();
        this.builder.endBlock();
        this.emitListItem("text4");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"* text2 **text3**\n* text4\n", (String)markup);
    }

    public void testBulletedListWithNestedSublist() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("first");
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("first.1");
        this.emitListItem("first.2");
        this.builder.endBlock();
        this.builder.endBlock();
        this.emitListItem("second");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"* first\n** first.1\n** first.2\n* second\n", (String)markup);
    }

    public void testBulletedListWithNestedSublist2() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("first");
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("second");
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("second.1");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        this.emitListItem("third");
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("fourth");
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        this.emitListItem("fourth.1");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"* first\n* second\n** second.1\n\n# third\n# fourth\n## fourth.1\n", (String)markup);
    }

    public void testParagraphListParagraph() {
        this.builder.beginDocument();
        this.paragraph("para 1");
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.emitListItem("list item 1");
        this.emitListItem("list item 2");
        this.builder.endBlock();
        this.paragraph("para 2");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"para 1\n\n* list item 1\n* list item 2\n\npara 2\n\n", (String)markup);
    }

    private void paragraph(String text) {
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters(text);
        this.builder.endBlock();
    }

    private void emitListItem(String text) {
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters(text);
        this.builder.endBlock();
    }

    public void testSpanWithAdjacentWhitespace() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("bolded");
        this.builder.endBlock();
        this.builder.characters(" suffix");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"prefix **bolded** suffix\n\n", (String)markup);
    }

    public void testEmptySpan() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.endBlock();
        this.builder.characters(" suffix");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"prefix suffix\n\n", (String)markup);
    }

    public void testMonospaceSpan() {
        this.builder.beginDocument();
        this.builder.characters("prefix ");
        this.builder.beginSpan(DocumentBuilder.SpanType.MONOSPACE, new Attributes());
        this.builder.characters("text");
        this.builder.endSpan();
        this.builder.characters(" suffix");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"prefix %{font-family:monospace;}text% suffix\n\n", (String)markup);
    }

    public void testTableWithEmptyCells() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new Attributes());
        this.builder.characters("content");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new Attributes());
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"|content| |\n\n", (String)markup);
    }

    public void testDivAfterImplicitParagraph() {
        this.builder.beginDocument();
        this.builder.characters("test");
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.characters("more ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.characters("text");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("text2");
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"test\n\nmore **text**\n\n# text2\n", (String)markup);
    }

    public void testDivWithinTableCell() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new Attributes());
        this.builder.characters("first");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.characters("content");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.characters("content2");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"|first| content content2|\n\n", (String)markup);
    }

    public void testEmptyBoldSpan() {
        this.builder.beginDocument();
        this.builder.characters("first ");
        this.builder.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        this.builder.endSpan();
        this.builder.characters("second");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"first second\n\n", (String)markup);
    }

    public void testProtectionAgainstNestedSpans() {
        this.builder.beginDocument();
        this.builder.beginSpan(DocumentBuilder.SpanType.SPAN, new Attributes(null, null, "color:blue;", null));
        this.builder.characters("first");
        this.builder.beginSpan(DocumentBuilder.SpanType.SPAN, new Attributes(null, null, "text-decoration:underline;", null));
        this.builder.characters(" second");
        this.builder.endSpan();
        this.builder.endSpan();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"%{color:blue;}first second%\n\n", (String)markup);
    }

    public void testLineBreak() {
        this.builder.beginDocument();
        this.builder.characters("line");
        this.builder.lineBreak();
        this.builder.characters("break");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"line\nbreak\n\n", (String)markup);
    }

    public void testLineBreak_ExplicitBlockAfterExtendedBlock() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("one\n\n\ntwo");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("line");
        this.builder.lineBreak();
        this.builder.characters("break");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"bc.. one\n\n\ntwo\n\np. line\nbreak\n\n", (String)markup);
    }

    public void testLineBreakInFootnote() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.FOOTNOTE, new Attributes());
        this.builder.characters("line");
        this.builder.lineBreak();
        this.builder.characters("break");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"fn1. line\nbreak\n\n", (String)markup);
    }

    public void testLineBreakInPreformatted_Extended() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        this.builder.characters("line");
        this.builder.lineBreak();
        this.builder.lineBreak();
        this.builder.characters("break");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"pre.. line\n\nbreak\n\n", (String)markup);
    }

    public void testLineBreakInPreformatted() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        this.builder.characters("line");
        this.builder.lineBreak();
        this.builder.characters("break");
        this.builder.endBlock();
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"pre. line\nbreak\n\n", (String)markup);
    }

    public void testLink() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.link((Attributes)new LinkAttributes(), "#foo", "link to foo");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a \"link to foo\":#foo test\n\n", (String)markup);
    }

    public void testExternalLink() {
        this.builder.beginDocument();
        this.builder.characters("an ");
        this.builder.link((Attributes)new LinkAttributes(), "http://example.com/", "external link");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"an \"external link\":http://example.com/ test\n\n", (String)markup);
    }

    public void testLinkWithNullHref() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.link((Attributes)new LinkAttributes(), null, "link text");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a \"link text\": test\n\n", (String)markup);
    }

    public void testSpanLinkWithNullHref() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)new LinkAttributes());
        this.builder.characters("link text");
        this.builder.endSpan();
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a \"link text\": test\n\n", (String)markup);
    }

    public void testImageLink() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.imageLink((Attributes)new LinkAttributes(), (Attributes)new ImageAttributes(), "#foo", "fooImage.png");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a !fooImage.png!:#foo test\n\n", (String)markup);
    }

    public void testImage() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.image((Attributes)new ImageAttributes(), "fooImage.png");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a !fooImage.png! test\n\n", (String)markup);
    }

    public void testImageNoUrl() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.image((Attributes)new ImageAttributes(), null);
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a test\n\n", (String)markup);
    }

    public void testEntityReference() {
        this.builder.beginDocument();
        this.builder.characters("a ");
        this.builder.entityReference("copy");
        this.builder.characters(" test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a (c) test\n\n", (String)markup);
    }

    public void testEntityCopyright() {
        this.builder.beginDocument();
        this.builder.characters("a \u00a9 test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a (c) test\n\n", (String)markup);
    }

    public void testEntityReg() {
        this.builder.beginDocument();
        this.builder.characters("a \u00ae test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a (r) test\n\n", (String)markup);
    }

    public void testNonBreakingSpace() {
        this.builder.beginDocument();
        this.builder.characters("a \u00a0 test");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"a test\n\n", (String)markup);
    }

    public void testSpanOpensImplicitParagraph() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        this.builder.characters("// some code");
        this.builder.endBlock();
        this.builder.beginSpan(DocumentBuilder.SpanType.DELETED, new Attributes());
        this.builder.characters("redacted");
        this.builder.endSpan();
        this.builder.characters(" text");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)"bc. // some code\n\n-redacted- text\n\n", (String)markup);
    }

    public void testSpanSuperscript() {
        this.assertSpan("begin ^span text^ end\n\n", DocumentBuilder.SpanType.SUPERSCRIPT);
    }

    public void testSpanSubscript() {
        this.assertSpan("begin ~span text~ end\n\n", DocumentBuilder.SpanType.SUBSCRIPT);
    }

    public void testSpanBold() {
        this.assertSpan("begin **span text** end\n\n", DocumentBuilder.SpanType.BOLD);
    }

    public void testSpanCitation() {
        this.assertSpan("begin??span text??end\n\n", DocumentBuilder.SpanType.CITATION);
    }

    public void testSpanCode() {
        this.assertSpan("begin @span text@ end\n\n", DocumentBuilder.SpanType.CODE);
    }

    public void testSpanDeleted() {
        this.assertSpan("begin -span text- end\n\n", DocumentBuilder.SpanType.DELETED);
    }

    public void testSpanEmphasis() {
        this.assertSpan("begin _span text_ end\n\n", DocumentBuilder.SpanType.EMPHASIS);
    }

    public void testSpanInserted() {
        this.assertSpan("begin +span text+ end\n\n", DocumentBuilder.SpanType.INSERTED);
    }

    public void testSpanItalic() {
        this.assertSpan("begin __span text__ end\n\n", DocumentBuilder.SpanType.ITALIC);
    }

    public void testSpanMonospace() {
        this.assertSpan("begin %{font-family:monospace;}span text% end\n\n", DocumentBuilder.SpanType.MONOSPACE);
    }

    public void testSpanQuote() {
        this.assertSpan("begin %span text% end\n\n", DocumentBuilder.SpanType.QUOTE);
    }

    public void testSpanSpan() {
        this.assertSpan("begin %span text% end\n\n", DocumentBuilder.SpanType.SPAN);
    }

    public void testSpanStrong() {
        this.assertSpan("begin *span text* end\n\n", DocumentBuilder.SpanType.STRONG);
    }

    public void testSpanUnderlined() {
        this.assertSpan("begin %{text-decoration:underline;}span text% end\n\n", DocumentBuilder.SpanType.UNDERLINED);
    }

    private void assertSpan(String expected, DocumentBuilder.SpanType spanType) {
        this.builder.beginDocument();
        this.builder.characters("begin");
        this.builder.beginSpan(spanType, new Attributes());
        this.builder.characters("span text");
        this.builder.endSpan();
        this.builder.characters("end");
        this.builder.endDocument();
        String markup = this.out.toString();
        TestUtil.println(markup);
        TextileDocumentBuilderTest.assertEquals((String)expected, (String)markup);
    }
}

