/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.RoundedRectangleUtil;

public class SlidableRoundedRectangleAnchor
extends SlidableAnchor {
    private final Dimension offset = new Dimension();

    public SlidableRoundedRectangleAnchor(NodeFigure figure) {
        super((IFigure)figure);
    }

    public SlidableRoundedRectangleAnchor(NodeFigure figure, PrecisionPoint p) {
        super((IFigure)figure, p);
    }

    protected Rectangle getBox() {
        PrecisionRectangle rBox = null;
        Object figure = this.getFigure();
        if (figure instanceof IRoundedRectangleFigure) {
            rBox = new PrecisionRectangle(((IRoundedRectangleFigure)((IFigure)figure)).getRoundedRectangleBounds());
        } else if (figure instanceof IFigure) {
            rBox = new PrecisionRectangle(this.getOwner().getBounds());
        }
        if (rBox != null) {
            ((IFigure)figure).translateToAbsolute((Translatable)rBox);
            rBox.expand(this.offset.width, this.offset.height);
        }
        return rBox;
    }

    private Object getFigure() {
        Object result = null;
        if (this.getOwner().getChildren().size() > 0) {
            result = this.getOwner().getChildren().get(0);
        }
        return result;
    }

    public PointList getPolygonPoints() {
        PointList points = null;
        if (this.getFigure() instanceof IRoundedRectangleFigure) {
            IRoundedRectangleFigure packageFigure = (IRoundedRectangleFigure)((IFigure)this.getFigure());
            Rectangle packageHeader = packageFigure.getPackageHeader().getCopy();
            packageFigure.translateToAbsolute((Translatable)packageHeader);
            if (!packageHeader.isEmpty()) {
                points = new PointList(5);
                Rectangle anchorableRectangle = this.getBox();
                points.addPoint(anchorableRectangle.x, anchorableRectangle.y);
                points.addPoint(anchorableRectangle.x + packageHeader.width, anchorableRectangle.y);
                points.addPoint(anchorableRectangle.x + packageHeader.width, anchorableRectangle.y + packageHeader.height);
                points.addPoint(anchorableRectangle.x + anchorableRectangle.width, anchorableRectangle.y + packageHeader.height);
                points.addPoint(anchorableRectangle.x + anchorableRectangle.width, anchorableRectangle.y + anchorableRectangle.height);
                points.addPoint(anchorableRectangle.x, anchorableRectangle.y + anchorableRectangle.height);
                points.addPoint(anchorableRectangle.x, anchorableRectangle.y);
            }
        }
        return points != null ? points : super.getPolygonPoints();
    }

    protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
        PointList pointList = null;
        Object figure = this.getFigure();
        if (figure instanceof IRoundedRectangleFigure) {
            if (!((IRoundedRectangleFigure)figure).getPackageHeader().isEmpty()) {
                PointList polygon = this.getPolygonPoints();
                pointList = new LineSeg(ownReference, foreignReference).getLineIntersectionsWithLineSegs(polygon);
            } else {
                Rectangle rect = this.getBox();
                Dimension dimension = null;
                if (figure instanceof IRoundedRectangleFigure) {
                    ((IRoundedRectangleFigure)figure).setOval(((IRoundedRectangleFigure)figure).isOval());
                    dimension = ((IRoundedRectangleFigure)figure).getCornerDimensions().getCopy();
                } else {
                    dimension = new Dimension();
                }
                if (rect.height < dimension.height) {
                    dimension.height = rect.height;
                }
                if (rect.width < dimension.width) {
                    dimension.width = rect.width;
                }
                PrecisionRectangle corner = new PrecisionRectangle(new Rectangle(0, 0, dimension.width, dimension.height));
                ((IFigure)figure).translateToAbsolute((Translatable)corner);
                pointList = RoundedRectangleUtil.getLineIntersectionsWithRoundedRectangle(new LineSeg(ownReference, foreignReference), rect.x, rect.y, rect.width, rect.height, corner.width, corner.height);
            }
        } else {
            pointList = super.getIntersectionPoints(ownReference, foreignReference);
        }
        return pointList;
    }

    public Point getLocation(Point refParent, Point refPort) {
        return super.getLocation(refParent, refPort);
    }

    public void setOffset(Dimension portOffset) {
        this.offset.height = portOffset.height;
        this.offset.width = portOffset.width;
    }
}

