/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.SyncKind;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.SyncStyles;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncRegistry;
import org.eclipse.papyrus.infra.sync.service.AbstractSyncTrigger;
import org.eclipse.papyrus.infra.sync.service.ISyncAction;
import org.eclipse.papyrus.infra.sync.service.ISyncService;

public abstract class EditPartSyncTrigger<M extends EObject, T extends EditPart, X>
extends AbstractSyncTrigger {
    private final Class<? extends SyncRegistry<M, T, X>> registryType;

    public EditPartSyncTrigger(Class<? extends SyncRegistry<M, T, X>> registryType) {
        this.registryType = registryType;
    }

    public ISyncAction trigger(ISyncService syncService, Object object) {
        EditPart editPart;
        Object model;
        ISyncAction result = null;
        if (object instanceof EditPart && (model = (editPart = (EditPart)object).getModel()) instanceof View) {
            SyncKind kind = SyncStyles.getSyncKind((View)model);
            result = this.trigger(kind);
        }
        return result;
    }

    protected ISyncAction trigger(final SyncKind syncKind) {
        return new ISyncAction(){

            public IStatus perform(final ISyncService syncService, Object object) {
                final IStatus[] result = new IStatus[]{Status.OK_STATUS};
                final EditPart editPart = (EditPart)object;
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)((View)editPart.getModel()));
                try {
                    GMFUnsafe.write(domain, new Runnable(){

                        @Override
                        public void run() {
                            result[0] = EditPartSyncTrigger.this.doTrigger(syncService, editPart, syncKind);
                        }
                    });
                }
                catch (InterruptedException e) {
                    result[0] = new Status(4, "org.eclipse.papyrus.infra.gmfdiag.common", "Synchronization trigger was interrupted", (Throwable)e);
                }
                catch (RollbackException e) {
                    result[0] = e.getStatus();
                }
                return result[0];
            }
        };
    }

    protected IStatus doTrigger(ISyncService syncService, EditPart editPart, SyncKind syncKind) {
        IStatus result = Status.OK_STATUS;
        SyncRegistry registry = null;
        EObject model = null;
        EditPart backend = null;
        try {
            registry = syncService.getSyncRegistry(this.registryType);
            model = (EObject)AdapterUtils.adapt((Object)editPart, (Class)registry.getModelType(), null);
            backend = (EditPart)registry.getBackendType().cast(editPart);
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.papyrus.infra.gmfdiag.common", "Failed to access synchronization registry", (Throwable)e);
        }
        if (registry != null && model != null) {
            switch (syncKind) {
                case MASTER: {
                    SyncBucket<EObject, EditPart, X> bucket = registry.getBucket((Object)model);
                    if (bucket != null) break;
                    bucket = this.createSyncBucket(model, backend);
                    registry.register(bucket);
                    break;
                }
                case SLAVE: {
                    registry.synchronize((Object)backend);
                    break;
                }
                default: {
                    result = new Status(4, "org.eclipse.papyrus.infra.gmfdiag.common", "Unsupported synchronization kind: " + (Object)((Object)syncKind), null);
                }
            }
        }
        return result;
    }

    protected abstract SyncBucket<M, T, X> createSyncBucket(M var1, T var2);
}

