/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.commands.handler;

import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.papyrus.views.modelexplorer.DirectEditorEditingSupport;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class RenameNamedElementHandler
extends AbstractCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        NamedElement namedElement;
        String currentName;
        Object result = UnexecutableCommand.INSTANCE;
        final TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        EObject selectedElement = this.getSelectedElement();
        if (selectedElement instanceof NamedElement && (currentName = (namedElement = (NamedElement)selectedElement).getName()) != null) {
            result = new CommandWrapper("Rename", "Change the name of an element", null){

                public boolean canExecute() {
                    return !this.isPrepared || this.basicCanExecute();
                }

                protected final boolean basicCanExecute() {
                    return super.canExecute();
                }

                public void execute() {
                    if (!this.basicCanExecute()) {
                        throw new OperationCanceledException();
                    }
                    super.execute();
                }

                protected Command createCommand() {
                    SetRequest request;
                    IElementEditService edit;
                    String name;
                    UnexecutableCommand result = UnexecutableCommand.INSTANCE;
                    InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Rename...", "New name:", currentName, null);
                    if (dialog.open() == 0 && !Strings.isNullOrEmpty((String)(name = dialog.getValue())) && !name.equals(currentName) && (edit = ElementEditServiceUtils.getCommandProvider((Object)namedElement)).canEdit((IEditCommandRequest)(request = new SetRequest(editingDomain, (EObject)namedElement, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__NAME, (Object)name)))) {
                        result = (Command)ICommandWrapper.wrap((Object)edit.getEditCommand((IEditCommandRequest)request), Command.class);
                    }
                    return result;
                }
            };
        }
        return result;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean enabled = super.computeEnabled(context);
        if (enabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            enabled = !EMFHelper.isReadOnly((EObject)selection) && !this.isHandledByDirectEditor(selection);
        }
        return enabled;
    }

    protected boolean isHandledByDirectEditor(EObject element) {
        return DirectEditorEditingSupport.getConfiguration((EObject)element) != null;
    }
}

