/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimatableScrollPane;
import org.eclipse.nebula.widgets.richtext.RichTextPainter;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.HTMLRenderer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class RichTextRenderer
implements HTMLRenderer {
    protected RichTextPainter painter;
    protected ImageFigure renderFigure;
    protected Image htmlImage;
    private boolean validated;
    protected AnimatableScrollPane contentPane;

    @Override
    public IFigure getFigure() {
        this.renderFigure = new ImageFigure();
        this.renderFigure.setOpaque(false);
        this.contentPane = new AnimatableScrollPane();
        this.contentPane.setOpaque(false);
        this.contentPane.setScrollBarVisibility(0);
        this.contentPane.setContents((IFigure)this.renderFigure);
        this.painter = new RichTextPainter(true);
        this.validated = false;
        return this.contentPane;
    }

    @Override
    public void paintHTML(String text, int width, int height, int x, int y) {
        if (this.renderFigure == null || this.painter == null || this.contentPane == null) {
            return;
        }
        if (!this.validated) {
            this.contentPane.setPreferredSize(width, height);
            this.contentPane.validate();
        }
        if (this.htmlImage != null) {
            this.htmlImage.dispose();
        }
        this.htmlImage = this.getTransparentBackground(Display.getDefault(), width, height);
        if (this.htmlImage == null) {
            this.htmlImage = new Image((Device)Display.getDefault(), width, height);
        }
        if (this.htmlImage != null) {
            GC gc = new GC((Drawable)this.htmlImage);
            Rectangle bounds = new Rectangle(x, y, width, height);
            this.painter.preCalculate(text != null ? text : "", gc, bounds, true);
            boolean changeBounds = false;
            if (width < this.getPreferredSize().x) {
                width = this.getPreferredSize().x;
                changeBounds = true;
            }
            if (height < this.getPreferredSize().y) {
                height = this.getPreferredSize().y;
                changeBounds = true;
            }
            if (changeBounds) {
                gc.dispose();
                this.htmlImage.dispose();
                this.htmlImage = this.getTransparentBackground(Display.getDefault(), width, height);
                if (this.htmlImage == null) {
                    this.htmlImage = new Image((Device)Display.getDefault(), width, height);
                }
                gc = new GC((Drawable)this.htmlImage);
                bounds = new Rectangle(x, y, width, height);
            }
            this.painter.paintHTML(text != null ? text : "", gc, bounds);
            if (gc != null) {
                gc.dispose();
            }
            this.renderFigure.setImage(this.htmlImage);
        }
    }

    @Override
    public Point getPreferredSize() {
        return this.painter.getPreferredSize();
    }

    private Image getTransparentBackground(Display device, int width, int height) {
        try {
            Image src = new Image((Device)device, width, height);
            ImageData imageData = src.getImageData();
            imageData.alpha = 0;
            src.dispose();
            return new Image((Device)device, imageData);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }
}

