/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import org.eclipse.php.formatter.core.HTMLFormatterFactoryForPhpCode;
import org.eclipse.wst.html.core.internal.format.HTMLElementFormatter;
import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLElementFormatterForPhpCode
extends HTMLElementFormatter {
    protected boolean canInsertBreakAfter(Node node) {
        if ("PHP".equals(node.getNodeName())) {
            return false;
        }
        Node next = node.getNextSibling();
        if (next != null && "PHP".equals(next.getNodeName())) {
            return false;
        }
        return super.canInsertBreakAfter(node);
    }

    protected boolean canInsertBreakBefore(Node node) {
        if ("PHP".equals(node.getNodeName())) {
            return false;
        }
        Node prev = node.getPreviousSibling();
        if (prev != null && "PHP".equals(prev.getNodeName())) {
            return false;
        }
        return super.canInsertBreakBefore(node);
    }

    protected void formatChildNodes(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (!node.hasChildNodes()) {
            return;
        }
        node.normalize();
        boolean indent = false;
        if (contraints != null) {
            indent = contraints.getFormatWithSiblingIndent();
            contraints.setFormatWithSiblingIndent(false);
        }
        boolean insertBreak = true;
        IDOMNode child = (IDOMNode)node.getFirstChild();
        while (child != null) {
            IStructuredFormatter formatter;
            if (child.getParentNode() != node) break;
            IDOMNode next = (IDOMNode)child.getNextSibling();
            if (insertBreak && this.canInsertBreakBefore((Node)child)) {
                this.insertBreakBefore(child, contraints);
            }
            if ((formatter = HTMLFormatterFactoryForPhpCode.getInstance().createFormatter((Node)child, this.getFormatPreferences())) != null) {
                if (formatter instanceof HTMLFormatter) {
                    HTMLFormatter htmlFormatter = (HTMLFormatter)formatter;
                    htmlFormatter.format(child, contraints);
                } else {
                    formatter.format((Node)child);
                }
            }
            if (this.canInsertBreakAfter((Node)child)) {
                this.insertBreakAfter(child, contraints);
                insertBreak = false;
            } else {
                insertBreak = true;
            }
            child = next;
        }
        if (contraints != null) {
            contraints.setFormatWithSiblingIndent(indent);
        }
    }

    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        Attr attr = null;
        if (node instanceof Element) {
            attr = ((Element)node).getAttributeNode("style");
        }
        if (attr == null || attr.getValue().indexOf("<?") == -1) {
            super.formatNode(node, contraints);
        } else {
            this.formatChildNodes(node, contraints);
        }
    }
}

