/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.commands.internal.HandlerServiceHandler;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.commands.internal.SetEnabled;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.riena.e4.launcher.part.HandlerActivation;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.osgi.framework.BundleContext;

public class E4HandlerProxy
implements IHandlerListener,
IElementUpdater {
    public HandlerActivation activation = null;
    private final Command command;
    private final IHandler handler;

    public E4HandlerProxy(Command command, IHandler handler) {
        this.command = command;
        this.handler = handler;
        handler.addHandlerListener((IHandlerListener)this);
    }

    @CanExecute
    public boolean canExecute(IEclipseContext context, @Optional IEvaluationContext staticContext, MApplication application) {
        if (this.handler instanceof IHandler2) {
            IEvaluationContext ctx = staticContext;
            if (ctx == null) {
                ctx = new ExpressionContext(application.getContext());
            }
            ((IHandler2)this.handler).setEnabled((Object)ctx);
        }
        return this.handler.isEnabled();
    }

    @Execute
    public Object execute(IEclipseContext context, @Optional @Named(value="parmMap::") Map parms, @Optional Event trigger, @Optional IEvaluationContext staticContext) throws ExecutionException, NotHandledException {
        Activator.trace((String)"/trace/commands", (String)("execute " + this.command + " and " + this.handler + " with: " + context), null);
        IEvaluationContext appContext = staticContext;
        if (appContext == null) {
            appContext = new ExpressionContext(context);
        }
        ExecutionEvent event = new ExecutionEvent(this.command, parms == null ? Collections.EMPTY_MAP : parms, (Object)trigger, (Object)appContext);
        if (this.handler != null && this.handler.isHandled()) {
            Object returnValue = this.handler.execute(event);
            return returnValue;
        }
        return null;
    }

    public IHandler getHandler() {
        return this.handler;
    }

    public void handlerChanged(HandlerEvent handlerEvent) {
        IEclipseContext appContext;
        IHandler handler = this.command.getHandler();
        if (handler instanceof HandlerServiceHandler && HandlerServiceImpl.lookUpHandler((IEclipseContext)(appContext = this.getWorkbenchContext()), (String)this.command.getId()) == this) {
            ((HandlerServiceHandler)handler).fireHandlerChanged(handlerEvent);
        }
    }

    private IEclipseContext getWorkbenchContext() {
        Activator plugin = Activator.getDefault();
        if (plugin == null) {
            return null;
        }
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)plugin.getContext());
        return serviceContext.getActiveLeaf();
    }

    public void updateElement(UIElement element, Map parameters) {
        if (this.handler instanceof IElementUpdater) {
            ((IElementUpdater)this.handler).updateElement(element, parameters);
        }
    }

    @SetEnabled
    void setEnabled(@Optional IEvaluationContext evalContext) {
        if (evalContext == null) {
            IEclipseContext appContext = this.getWorkbenchContext();
            evalContext = new ExpressionContext(appContext);
        }
        if (this.handler instanceof IHandler2) {
            ((IHandler2)this.handler).setEnabled((Object)evalContext);
        }
    }
}

