/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.security;

import javax.inject.Inject;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.e4.launcher.security.LoginExecutor;
import org.eclipse.riena.navigation.ui.login.ILoginDialogView;
import org.eclipse.riena.navigation.ui.swt.application.LoginNonActivityTimer;
import org.eclipse.riena.navigation.ui.swt.splashHandlers.AbstractLoginSplashHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LoginHelper {
    private static final String ATTRIBUTE_NON_ACTIVITY_DURATION = "nonActivityDuration";
    @Inject
    private IExtensionRegistry extensionRegistry;
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext eclipseContext;

    public LoginNonActivityTimer.ILoginExecutor<Integer> checkLogin() {
        LoginNonActivityTimer.ILoginExecutor<Integer> loginExecutor = null;
        try {
            loginExecutor = this.createLoginExecutor();
        }
        catch (CoreException e) {
            this.logger.error((Throwable)e);
            System.exit(0);
        }
        if (loginExecutor != null && !IApplication.EXIT_OK.equals(loginExecutor.performLogin())) {
            System.exit(0);
        }
        return loginExecutor;
    }

    private LoginNonActivityTimer.ILoginExecutor<Integer> createLoginExecutor() throws CoreException {
        IConfigurationElement[] loginSplashExtensions = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.riena.navigation.ui.swt.loginSplashViewDefinition");
        if (loginSplashExtensions.length > 0) {
            return this.loginExecutorForSplash(loginSplashExtensions[0]);
        }
        IConfigurationElement[] loginExtensions = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.riena.navigation.ui.loginDialogViewDefinition");
        if (loginExtensions.length > 0) {
            return this.loginExecutorForDialog(loginExtensions[0]);
        }
        return null;
    }

    private LoginNonActivityTimer.ILoginExecutor<Integer> loginExecutorForDialog(IConfigurationElement iConfigurationElement) throws CoreException {
        String attribute = iConfigurationElement.getAttribute(ATTRIBUTE_NON_ACTIVITY_DURATION);
        final ILoginDialogView loginDialogView = (ILoginDialogView)iConfigurationElement.createExecutableExtension("viewClass");
        return new LoginExecutor(this.eclipseContext, Integer.parseInt(attribute)){

            public Integer performLogin() {
                Realm realm = SWTObservables.getRealm((Display)Display.getCurrent());
                do {
                    Realm.runWithDefault((Realm)realm, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            loginDialogView.build();
                        }
                    });
                } while (IApplication.EXIT_RESTART.equals(loginDialogView.getResult()));
                return loginDialogView.getResult();
            }
        };
    }

    private LoginNonActivityTimer.ILoginExecutor<Integer> loginExecutorForSplash(final IConfigurationElement iConfigurationElement) throws CoreException {
        String attribute = iConfigurationElement.getAttribute(ATTRIBUTE_NON_ACTIVITY_DURATION);
        return new LoginExecutor(this.eclipseContext, Integer.parseInt(attribute)){

            public Integer performLogin() {
                final AbstractLoginSplashHandler loginSplashHandler = this.getLoginSplashHandler();
                Realm realm = SWTObservables.getRealm((Display)Display.getCurrent());
                Realm.runWithDefault((Realm)realm, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = new Shell(this.getDisplay(), 65544);
                        this.initializeShellBackgroundImage(shell, this.getBackgroundImagePath());
                        loginSplashHandler.init(shell);
                        shell.setLocation((shell.getDisplay().getBounds().width - shell.getSize().x) / 2, (shell.getDisplay().getBounds().height - shell.getSize().y) / 2);
                        shell.open();
                        while (!shell.isDisposed()) {
                            if (this.getDisplay().readAndDispatch()) continue;
                            this.getDisplay().sleep();
                        }
                    }
                });
                return loginSplashHandler.getResult();
            }

            private void initializeShellBackgroundImage(Shell shell, String imageName) {
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)((RegistryContributor)iConfigurationElement.getContributor()).getActualName(), (String)this.getBackgroundImagePath());
                Image image = imageDescriptor.createImage();
                shell.setSize(image.getBounds().width, image.getBounds().height);
                shell.setBackgroundImage(image);
            }

            private AbstractLoginSplashHandler getLoginSplashHandler() {
                return new AbstractLoginSplashHandler(){};
            }

            private String getBackgroundImagePath() {
                return "splash.bmp";
            }

            private Display getDisplay() {
                return Display.getCurrent();
            }
        };
    }
}

