/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.ListBean;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SnippetComboRidget004 {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = UIControlsFactory.createShell((Display)display);
            GridLayoutFactory.swtDefaults().numColumns(2).spacing(10, 5).applyTo((Composite)shell);
            shell.setText(SnippetComboRidget004.class.getSimpleName());
            UIControlsFactory.createLabel((Composite)shell, (String)"ComboRidget:");
            Combo combo = UIControlsFactory.createCombo((Composite)shell);
            UIControlsFactory.createLabel((Composite)shell, (String)"Selection:");
            Label label = UIControlsFactory.createLabel((Composite)shell, (String)"Monday");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
            Button buttonDel = new Button((Composite)shell, 8);
            buttonDel.setText("Delete selection - shows error");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttonDel);
            Button buttonSel = new Button((Composite)shell, 8);
            buttonSel.setText("Select element - hides error");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttonSel);
            final IComboRidget comboRidget = (IComboRidget)SwtRidgetFactory.createRidget((Object)combo);
            final ListBean input = SnippetComboRidget004.createInput();
            comboRidget.bindToModel((Object)input, "values", String.class, null, (Object)label, "text");
            comboRidget.updateFromModel();
            comboRidget.setMarkSelectionMismatch(true);
            IActionRidget actionDel = (IActionRidget)SwtRidgetFactory.createRidget((Object)buttonDel);
            actionDel.addListener(new IActionListener(){

                public void callback() {
                    Object sel = comboRidget.getSelection();
                    if (sel != null) {
                        System.out.println(String.format("Removing '%s' from model", sel));
                        input.getValues().remove(sel);
                        comboRidget.updateFromModel();
                    }
                }
            });
            IActionRidget actionSel = (IActionRidget)SwtRidgetFactory.createRidget((Object)buttonSel);
            actionSel.addListener(new IActionListener(){

                public void callback() {
                    if (!input.getValues().isEmpty()) {
                        comboRidget.setSelection(0);
                    }
                }
            });
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private static ListBean createInput() {
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String day = stringArray[n2];
            values.add(day);
            ++n2;
        }
        return new ListBean(values);
    }
}

