/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.databinding;

import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.logging.ILogCatcher;

public class DatabindingLogCatcher
implements ILogCatcher {
    public void attach() {
        Policy.setLog((ILogger)new DatabindingLoggingDelegate());
    }

    public void detach() {
        Policy.setLog(null);
    }

    private static class DatabindingLoggingDelegate
    implements ILogger {
        private static final Logger LOGGER = Log4r.getLogger(Policy.class);

        private DatabindingLoggingDelegate() {
        }

        public void log(IStatus status) {
            StringBuilder bob = new StringBuilder("Message: ");
            bob.append(status.getMessage()).append(", Code: ");
            bob.append(status.getCode()).append(", Plugin: ");
            bob.append(status.getPlugin());
            LOGGER.log(this.getLogLevel(status), bob.toString(), status.getException());
        }

        private int getLogLevel(IStatus status) {
            switch (status.getSeverity()) {
                case 4: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 0: {
                    return 3;
                }
            }
            return 4;
        }
    }
}

