/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.util.Map;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IRidgetResolver;

public class ComplexRidgetResolver
implements IRidgetResolver {
    @Override
    public IRidget getRidget(String id, Map<String, IRidget> ridgets) {
        IRidgetContainer parent;
        IRidget result = ridgets.get(id);
        if (result == null && id.indexOf(46) != -1 && (parent = ComplexRidgetResolver.getContainer(id, ridgets)) != null) {
            String childId = ComplexRidgetResolver.getChildId(id);
            result = parent.getRidget(childId);
        }
        return result;
    }

    @Override
    public <R extends IRidget> IRidget addRidget(String id, R ridget, IRidgetContainer toContainer, Map<String, IRidget> ridgets) {
        IRidget oldRidget = this.getRidget(id, ridgets);
        String childId = ComplexRidgetResolver.getChildId(id);
        if (childId.equals(id)) {
            ridgets.put(id, ridget);
        } else {
            IRidgetContainer container = ComplexRidgetResolver.getContainer(id, ridgets);
            if (container != null) {
                container.addRidget(childId, ridget);
            } else {
                ridgets.put(id, ridget);
            }
        }
        return oldRidget;
    }

    @Override
    public IRidget removeRidget(String id, Map<String, IRidget> ridgets) {
        String childId = ComplexRidgetResolver.getChildId(id);
        if (childId.equals(id)) {
            return ridgets.remove(id);
        }
        IRidgetContainer container = ComplexRidgetResolver.getContainer(id, ridgets);
        if (container != null) {
            Object result = container.getRidget(childId);
            container.removeRidget(childId);
            return result;
        }
        return null;
    }

    private static String getChildId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return id;
        }
        if (id.indexOf(46) != -1) {
            return id.substring(id.lastIndexOf(46) + 1);
        }
        return id;
    }

    private static IRidgetContainer getContainer(String id, Map<String, IRidget> ridgets) {
        String parentId;
        IRidget parent;
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        if (id.indexOf(46) != -1 && (parent = ridgets.get(parentId = id.substring(0, id.lastIndexOf(46)))) instanceof IRidgetContainer) {
            return (IRidgetContainer)((Object)parent);
        }
        return null;
    }
}

