/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.riena.ui.ridgets.databinding.ConversionFailure;

public class StringToGregorianCalendarConverter
extends Converter {
    private static final DateFormat FORMAT = DateFormat.getDateInstance(2);

    public StringToGregorianCalendarConverter() {
        super(String.class, GregorianCalendar.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object fromObject) {
        if (fromObject == null || "".equals(fromObject)) {
            return null;
        }
        try {
            DateFormat dateFormat = FORMAT;
            synchronized (dateFormat) {
                Date date = FORMAT.parse(fromObject.toString());
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
        }
        catch (ParseException e) {
            throw new ConversionFailure("Cannot convert \"" + fromObject + "\" to GregorianCalendar.", e);
        }
    }
}

