/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.marker.AbstractMessageMarkerViewer;

public class MessageBoxMessageMarkerViewer
extends AbstractMessageMarkerViewer {
    private final IMessageBoxRidget messageBoxRidget;

    public MessageBoxMessageMarkerViewer(IMessageBoxRidget messageBoxRidget) {
        this.messageBoxRidget = messageBoxRidget;
        this.setVisible(false);
    }

    @Override
    protected void hideMessages(IBasicMarkableRidget ridget) {
    }

    @Override
    protected void showMessages(IBasicMarkableRidget ridget) {
        if (this.isVisible()) {
            String message = this.getMessage();
            if (message.length() > 0) {
                this.messageBoxRidget.setText(message);
                this.messageBoxRidget.show();
            }
            this.setVisible(false);
        }
    }

    @Override
    protected String getMessageSeparator() {
        return "\n";
    }

    private String getMessage() {
        LinkedHashSet<IMessageMarker> allMessageMarker = new LinkedHashSet<IMessageMarker>();
        IBasicMarkableRidget nextMarkableAdapter2 = null;
        HashSet<IBasicMarkableRidget> localMarkableAdapter = new HashSet<IBasicMarkableRidget>();
        localMarkableAdapter.addAll(this.getRidgets());
        for (IBasicMarkableRidget nextMarkableAdapter2 : localMarkableAdapter) {
            allMessageMarker.addAll(this.getMessageMarker(nextMarkableAdapter2, false));
        }
        ArrayList<IMessageMarker> sortedMarkers = new ArrayList<IMessageMarker>(allMessageMarker);
        Collections.sort(sortedMarkers, new AbstractMessageMarkerViewer.MessageMarkerComparator());
        return MessageBoxMessageMarkerViewer.constructMessage(sortedMarkers, this.getMessageSeparator());
    }
}

