/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.util.ArraysUtil;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.nls.Messages;
import org.eclipse.riena.ui.ridgets.validation.Utils;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class ValidDecimal
implements IValidator,
IExecutableExtension {
    protected static final int DEFAULT_MAX_LENGTH = 15;
    protected static final int DEFAULT_NUMBER_OF_FRACTION_DIGITS = 2;
    private static final char FRENCH_GROUPING_SEPARATOR = '\u00a0';
    private boolean partialCheckSupported;
    private DecimalFormat format;
    private DecimalFormatSymbols symbols;
    private int numberOfFractionDigits;
    private int maxLength;
    private Locale locale;
    private boolean groupingInMessage = true;

    public ValidDecimal() {
        this(Locale.getDefault());
    }

    public ValidDecimal(Locale locale) {
        this(false, locale);
    }

    public ValidDecimal(boolean partialCheckSupported, Locale locale) {
        this(partialCheckSupported, 2, 15, false, locale);
    }

    public ValidDecimal(boolean partialCheckSupported, int numberOfFractionDigits, int maxLength, boolean withSign, Locale locale) {
        Assert.isNotNull((Object)locale);
        this.partialCheckSupported = partialCheckSupported;
        this.numberOfFractionDigits = numberOfFractionDigits;
        this.maxLength = maxLength;
        this.locale = locale;
    }

    public void setGroupingInMessage(boolean groupingInMessage) {
        this.groupingInMessage = groupingInMessage;
    }

    protected boolean isGroupingInMessage() {
        return this.groupingInMessage;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validate(Object value) {
        if (value != null) {
            if (!(value instanceof String)) {
                throw new ValidationFailure("ValidCharacters can only validate objects of type String.");
            }
            String string = Utils.removeWhitespace((String)value);
            if (string.length() > 0) {
                Object message4;
                ScanResult scanned = this.scan(string);
                if (!this.partialCheckSupported) {
                    if (scanned.decimalSeparatorIndex < 0) {
                        Character decSep = Character.valueOf(this.getSymbols().getDecimalSeparator());
                        String message2 = NLS.bind((String)Messages.ValidDecimal_error_noDecSep, (Object)decSep, (Object)string);
                        return ValidationRuleStatus.error(true, message2);
                    }
                    if (scanned.groupingSeparatorIndex > scanned.decimalSeparatorIndex) {
                        Character groupSep = Character.valueOf(this.getSymbols().getGroupingSeparator());
                        Character decSep = Character.valueOf(this.getSymbols().getDecimalSeparator());
                        String message3 = NLS.bind((String)Messages.ValidDecimal_error_trailingGroupSep, (Object[])new Object[]{groupSep, decSep, string});
                        return ValidationRuleStatus.error(true, message3);
                    }
                }
                if (scanned.lastAlienCharIndex > -1) {
                    String message4 = NLS.bind((String)Messages.ValidDecimal_error_alienChar, (Object)Character.valueOf(scanned.lastAlienCharacter), (Object)string);
                    return ValidationRuleStatus.error(true, message4);
                }
                try {
                    message4 = this.getFormat();
                    synchronized (message4) {
                        this.getFormat().parse(string);
                    }
                }
                catch (ParseException parseException) {
                    String message5 = NLS.bind((String)Messages.ValidDecimal_error_cannotParse, (Object)string);
                    return ValidationRuleStatus.error(true, message5);
                }
                if (scanned.length > this.maxLength) {
                    message4 = NLS.bind((String)Messages.ValidDecimal_error_maxLength, (Object)string, (Object)this.maxLength);
                    return ValidationRuleStatus.error(true, (String)message4);
                }
                if (scanned.fractionDigits > this.numberOfFractionDigits) {
                    message4 = NLS.bind((String)Messages.ValidDecimal_error_numberOfFractionDigits, (Object)string, (Object)this.numberOfFractionDigits);
                    return ValidationRuleStatus.error(true, (String)message4);
                }
            }
        }
        return ValidationRuleStatus.ok();
    }

    protected ScanResult scan(String string) {
        ScanResult result = new ScanResult();
        boolean acceptWhitespaceAsGroupingSeparator = Character.isWhitespace(this.getSymbols().getGroupingSeparator()) || this.getSymbols().getGroupingSeparator() == '\u00a0';
        char minusSign = this.getSymbols().getMinusSign();
        int t = 0;
        while (t < string.length()) {
            char currentChar = string.charAt(t);
            if (currentChar == this.getSymbols().getDecimalSeparator()) {
                result.decimalSeparatorIndex = t;
            } else if (currentChar == this.getSymbols().getGroupingSeparator() || Character.isWhitespace(currentChar) && acceptWhitespaceAsGroupingSeparator) {
                result.groupingSeparatorIndex = t;
            } else if (currentChar == minusSign) {
                result.minusSignIndex = t;
            } else if (!Character.isDigit(currentChar)) {
                result.lastAlienCharacter = currentChar;
                result.lastAlienCharIndex = t;
            } else if (Character.isDigit(currentChar)) {
                if (result.decimalSeparatorIndex == -1) {
                    ++result.length;
                } else {
                    ++result.fractionDigits;
                }
            }
            ++t;
        }
        return result;
    }

    protected DecimalFormat getFormat() {
        if (this.format == null) {
            this.format = (DecimalFormat)DecimalFormat.getInstance(this.locale);
            this.format.setMaximumFractionDigits(this.numberOfFractionDigits);
            this.format.setMaximumIntegerDigits(this.maxLength);
        }
        return this.format;
    }

    protected DecimalFormatSymbols getSymbols() {
        if (this.symbols == null) {
            this.symbols = this.getFormat().getDecimalFormatSymbols();
        }
        return this.symbols;
    }

    protected void setLocale(String[] localeArgs) {
        if (localeArgs.length > 0) {
            String language = localeArgs[0];
            String country = localeArgs.length > 1 ? localeArgs[1] : "";
            String variant = localeArgs.length > 2 ? localeArgs[2] : "";
            this.setLocale(new Locale(language, country, variant));
        }
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            Object[] args = PropertiesUtils.asArray((Object)data);
            int localStart = 0;
            if (args.length > 0) {
                if (args[0].equals(Boolean.TRUE.toString())) {
                    this.partialCheckSupported = true;
                    ++localStart;
                } else if (args[0].equals(Boolean.FALSE.toString())) {
                    this.partialCheckSupported = false;
                    ++localStart;
                }
            }
            if (args.length > 1 && args[1].length() > 0) {
                try {
                    this.numberOfFractionDigits = Integer.parseInt((String)args[1]);
                    ++localStart;
                    if (args.length > 2 && ((String)args[2]).length() > 0) {
                        this.maxLength = Integer.parseInt((String)args[2]);
                        ++localStart;
                        if (args.length > 3 && ((String)args[3]).length() > 0) {
                            if (((String)args[3]).equals(Boolean.TRUE.toString())) {
                                ++localStart;
                            } else if (((String)args[3]).equals(Boolean.FALSE.toString())) {
                                ++localStart;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (args.length > localStart) {
                String[] localArgs = (String[])ArraysUtil.copyRange((Object[])args, (int)localStart, (int)args.length);
                this.setLocale(localArgs);
            }
        }
    }

    protected static final class ScanResult {
        protected int decimalSeparatorIndex = -1;
        protected int groupingSeparatorIndex = -1;
        protected int minusSignIndex = -1;
        protected char lastAlienCharacter;
        protected int lastAlienCharIndex = -1;
        protected int length = 0;
        protected int fractionDigits = 0;

        private ScanResult() {
        }
    }
}

