/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib;

import java.util.Collection;
import java.util.Map;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.model.ClientModel;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.model.ServerModel;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolActionDelegate {
    public static ProtocolHandle requestStartProtocolAsClient(Map<Long, ProtocolMsgDefinition> map, Collection<String> collection, Collection<String> collection2, IProtocolHandshake iProtocolHandshake, IProtocolExceptionHandler iProtocolExceptionHandler, Boolean bl, String string, int n, Map<String, Object> map2) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("An user is requesting to start a client protocol. host= " + string + "; port=" + n + "."));
        ClientModel clientModel = ClientModel.getInstance();
        return clientModel.requestStartProtocol(map, collection, collection2, iProtocolHandshake, iProtocolExceptionHandler, bl, string, n, map2);
    }

    public static ProtocolHandle requestStartProtocolAsServer(int n, Map<Long, ProtocolMsgDefinition> map, Collection<String> collection, Collection<String> collection2, IProtocolHandshake iProtocolHandshake, IProtocolExceptionHandler iProtocolExceptionHandler, boolean bl) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("An user is requesting to start a server protocol at port " + n + "."));
        ServerModel serverModel = ServerModel.getInstance();
        return serverModel.startListeningToPort(n, map, collection, collection2, iProtocolHandshake, iProtocolExceptionHandler, bl);
    }

    public static void requestStopProtocol(ProtocolHandle protocolHandle) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("A user is requesting to stop the protocol identified by " + protocolHandle));
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.requestStopProtocol(protocolHandle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.stopListeningToPort(protocolHandle);
    }

    public static void requestRestartProtocol(ProtocolHandle protocolHandle) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("An user is requesting to restart the protocol identified by " + protocolHandle));
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.requestRestartProtocol(protocolHandle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.requestRestartProtocol(protocolHandle);
    }

    public static void sendMessageToServer(ProtocolHandle protocolHandle, ProtocolMessage protocolMessage) {
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.sendMessage(protocolHandle, protocolMessage);
    }

    public static boolean isProtocolRunning(ProtocolHandle protocolHandle) {
        return ClientModel.getInstance().isClientProtocolRunning(protocolHandle) || ServerModel.getInstance().isListeningToPort(protocolHandle);
    }
}

