/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NioOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 102400;
    private SocketChannel channel;
    private ByteBuffer buffer;

    NioOutputStream(SocketChannel socketChannel) {
        this.channel = socketChannel;
        this.buffer = ByteBuffer.allocate(102400);
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.flush();
            this.channel.close();
        }
    }

    public void flush() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    public void write(int n) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.flush();
        }
        this.buffer.put((byte)(n & 0xFF));
        this.flush();
    }

    public void write(byte[] byArray) throws IOException {
        if (this.buffer.remaining() < byArray.length) {
            this.flush();
        }
        this.buffer.put(byArray);
        this.flush();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer.remaining() < n2) {
            this.flush();
        }
        this.buffer.put(byArray, n, n2);
        this.flush();
    }
}

