/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.internal.migration.description.VSMExtendedMetaData;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMResourceHandler;
import org.eclipse.sirius.business.internal.migration.description.VSMVersionSAXParser;
import org.eclipse.sirius.business.internal.movida.DynamicVSMLoader;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointURIConverter;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointURIHandler;
import org.eclipse.sirius.common.ui.tools.api.editor.IEObjectNavigable;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.properties.validation.SiriusInterpreterErrorDecorator;
import org.eclipse.sirius.editor.tools.internal.actions.ValidateAction;
import org.eclipse.sirius.editor.tools.internal.presentation.CustomSiriusAdapterFactoryLabelProvider;
import org.eclipse.sirius.editor.tools.internal.presentation.GeneratedElementsLabelProvider;
import org.eclipse.sirius.editor.tools.internal.presentation.ModificationTrackingEnabler;
import org.eclipse.sirius.editor.tools.internal.presentation.RepresentationTemplateUpdateTrigger;
import org.eclipse.sirius.editor.tools.internal.presentation.VSMRequirementChangeAdapter;
import org.eclipse.sirius.editor.tools.internal.presentation.ValidationDecoration;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.template.RepresentationTemplateEditManager;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.util.DescriptionResourceImpl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.osgi.framework.Version;

public class CustomSiriusEditor
extends SiriusEditor
implements IEObjectNavigable {
    public static final String CONTEXT_ID = "org.eclipse.sirius.editor.siriusEditorContext";
    private final RepresentationTemplateUpdateTrigger templateUpdateTrigger = new RepresentationTemplateUpdateTrigger();
    private final ViewpointURIHandler vsmURIHandler;
    private CommandStackListener cmdStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            CustomSiriusEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CustomSiriusEditor.this.isDirty()) {
                        ToolBarManager tbm = CustomSiriusEditor.this.getToolBarManager();
                        ValidateAction action = CustomSiriusEditor.this.getValidateAction(tbm);
                        action.setImageDescriptor(ValidateAction.HIGHLIGHT_DESC);
                        tbm.update(true);
                    }
                }
            });
        }
    };
    private GeneratedElementsLabelProvider decoratingLabelProvider;
    private ValidationDecoration validationDecorator;
    private DynamicVSMLoader loader;
    private VSMRequirementChangeAdapter tracker;

    public CustomSiriusEditor() {
        this.editingDomain.getCommandStack().addCommandStackListener(this.cmdStackListener);
        this.editingDomain.getResourceSet().eAdapters().add((Object)new ECrossReferenceAdapter());
        this.editingDomain.getResourceSet().eAdapters().add((Object)new ModificationTrackingEnabler(this.editingDomain.getResourceSet()));
        this.vsmURIHandler = new ViewpointURIHandler(this.editingDomain.getResourceSet());
        if (Movida.isEnabled()) {
            ViewpointRegistry registry = (ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance();
            this.editingDomain.getResourceSet().setURIConverter((URIConverter)new ViewpointURIConverter(registry));
            this.loader = new DynamicVSMLoader(this.editingDomain.getResourceSet(), registry);
            this.loader.setErrorHandler(new Runnable(){

                @Override
                public void run() {
                    CustomSiriusEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)CustomSiriusEditor.this.getSite().getShell(), (String)"Error", (String)"The editor will be closed.");
                            CustomSiriusEditor.this.getSite().getPage().closeEditor((IEditorPart)CustomSiriusEditor.this, false);
                            CustomSiriusEditor.this.dispose();
                        }
                    });
                }
            });
        }
    }

    public Control getControl() {
        return this.getControl(0);
    }

    @Override
    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
        try {
            String uriAttribute;
            if ("org.eclipse.sirius.viewpointMarker".equals(marker.getType()) && (uriAttribute = marker.getAttribute("viewpointURIMarker", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException e) {
            SiriusEditorPlugin.INSTANCE.log((Object)e);
        }
        catch (WrappedException wrappedException) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean navigateToEObject(URI uri) {
        EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
        if (eObject != null) {
            this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
            return true;
        }
        return false;
    }

    @Override
    public void createPages() {
        super.createPages();
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(CONTEXT_ID);
        if (this.selectionViewer != null) {
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new CustomSiriusAdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !this.isEnvironmentResource(element) && !this.isMigrationAnnotation(element);
                }

                private boolean isEnvironmentResource(Object element) {
                    return element instanceof Resource && ((Resource)element).getURI() != null && "environment".equals(((Resource)element).getURI().scheme());
                }

                private boolean isMigrationAnnotation(Object element) {
                    return element instanceof DAnnotation && ((DAnnotation)element).eContainer() instanceof Group;
                }
            });
            this.validationDecorator = new ValidationDecoration();
            this.decoratingLabelProvider = Movida.isEnabled() ? new GeneratedElementsLabelProvider((ILabelProvider)this.selectionViewer.getLabelProvider(), (ILabelDecorator)this.validationDecorator){

                public String getText(Object element) {
                    Viewpoint viewpoint;
                    Resource resource;
                    String result = super.getText(element);
                    if (element instanceof Viewpoint && (resource = (viewpoint = (Viewpoint)element).eResource()) != null && resource.getResourceSet().getResources().indexOf((Object)resource) != 0) {
                        result = String.valueOf(result) + " (" + resource.getURI() + ")";
                    }
                    return result;
                }
            } : new GeneratedElementsLabelProvider((ILabelProvider)this.selectionViewer.getLabelProvider(), (ILabelDecorator)this.validationDecorator);
            this.decoratingLabelProvider.setLabelDecorator(new SiriusInterpreterErrorDecorator(this.getURIFromInput(this.getEditorInput())));
            if (Movida.isEnabled()) {
                this.customizeContentProvider();
            }
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)this.decoratingLabelProvider);
            this.selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    EObject original;
                    EObject selectedEObject;
                    ISelection selection = CustomSiriusEditor.this.selectionViewer.getSelection();
                    if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof EObject && RepresentationTemplateEditManager.INSTANCE.isGenerated(selectedEObject = (EObject)((StructuredSelection)selection).getFirstElement()) && (original = RepresentationTemplateEditManager.INSTANCE.getSourceElement(selectedEObject)) != null) {
                        CustomSiriusEditor.this.setSelectionToViewer(Collections.singleton(CustomSiriusEditor.this.editingDomain.getWrapper((Object)original)));
                    }
                }
            });
            this.selectionViewer.expandToLevel(4);
            ToolBarManager tbm = this.getToolBarManager();
            tbm.add((IAction)new ValidateAction(this.selectionViewer, this));
            tbm.update(true);
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.templateUpdateTrigger);
    }

    private void customizeContentProvider() {
        final ViewpointRegistry registry = (ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance();
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                if (object instanceof ResourceSet) {
                    Set<EObject> viewpoints = this.getRequiredViewpoints(registry, (ResourceSet)object);
                    ArrayList elements = Lists.newArrayList();
                    Resource mainResource = (Resource)((ResourceSet)object).getResources().get(0);
                    elements.add(mainResource);
                    for (Viewpoint additionalVP : Iterables.filter(viewpoints, Viewpoint.class)) {
                        Resource resource = additionalVP.eResource();
                        if (resource == null || resource == mainResource) continue;
                        elements.add(additionalVP);
                    }
                    return elements.toArray();
                }
                return super.getElements(object);
            }

            private Set<EObject> getRequiredViewpoints(ViewpointRegistry registry2, ResourceSet resourceSet) {
                HashSet viewpoints = Sets.newHashSet();
                for (final URI uri : CustomSiriusEditor.this.loader.getRequiredViewpoints()) {
                    Option provider = registry2.getProvider(uri);
                    if (!provider.some()) continue;
                    Resource res = resourceSet.getResource((URI)provider.get(), true);
                    viewpoints.add((EObject)Iterables.find((Iterable)registry2.getSiriusResourceHandler().collectViewpointDefinitions(res), (Predicate)new Predicate<Viewpoint>(){

                        public boolean apply(Viewpoint input) {
                            Option inputURI = new ViewpointQuery(input).getViewpointURI();
                            return inputURI.some() && ((URI)inputURI.get()).equals(uri);
                        }
                    }));
                }
                return viewpoints;
            }
        });
    }

    private ToolBarManager getToolBarManager() {
        return this.currentViewerPane.getToolBarManager();
    }

    private ValidateAction getValidateAction(ToolBarManager tbm) {
        IContributionItem[] contributions;
        IContributionItem[] iContributionItemArray = contributions = tbm.getItems();
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem contribution = iContributionItemArray[n2];
            if (contribution instanceof ActionContributionItem && contribution.getId().equals("ValidateActionFromEditor") && (action = ((ActionContributionItem)contribution).getAction()) instanceof ValidateAction) {
                return (ValidateAction)action;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void createModel() {
        URI resourceURI = this.getURIFromInput(this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        if (Movida.isEnabled()) {
            this.loader.protect(resource.getURI());
            this.tracker = new VSMRequirementChangeAdapter(resource, this.loader);
            this.tracker.install();
        }
    }

    private URI getURIFromInput(IEditorInput input) {
        URI result = input == null ? null : (input instanceof IFileEditorInput ? URI.createPlatformResourceURI((String)((IFileEditorInput)this.getEditorInput()).getFile().getFullPath().toString(), (boolean)false) : (input instanceof URIEditorInput ? ((URIEditorInput)input).getURI() : (input instanceof IPathEditorInput ? URI.createFileURI((String)((IPathEditorInput)input).getPath().toOSString()) : (input instanceof IURIEditorInput ? URI.createURI((String)((IURIEditorInput)input).getURI().toString()) : (URI)input.getAdapter(URI.class)))));
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.editingDomain.getCommandStack().removeCommandStackListener(this.cmdStackListener);
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.templateUpdateTrigger);
        if (this.decoratingLabelProvider != null) {
            this.decoratingLabelProvider.dispose();
        }
        if (Movida.isEnabled()) {
            this.loader.dispose();
            this.tracker.uninstall();
        }
    }

    @Override
    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : CustomSiriusEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !CustomSiriusEditor.this.isPersisted(resource) || CustomSiriusEditor.this.editingDomain.isReadOnly(resource) || resource.isTrackingModification() && !resource.isModified()) continue;
                    try {
                        CustomSiriusEditor.this.savedResources.add(resource);
                        if (resource instanceof XMLResource) {
                            ((XMLResource)resource).getDefaultSaveOptions().put("URI_HANDLER", CustomSiriusEditor.this.vsmURIHandler);
                        }
                        resource.save(Collections.emptyMap());
                    }
                    catch (Exception exception) {
                        CustomSiriusEditor.this.resourceToDiagnosticMap.put(resource, CustomSiriusEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            SiriusEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    @Override
    protected void beforeReload(Resource resource) {
        if (resource instanceof DescriptionResourceImpl) {
            VSMVersionSAXParser parser = new VSMVersionSAXParser(resource.getURI());
            String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
            boolean migrationIsNeeded = true;
            if (loadedVersion != null) {
                migrationIsNeeded = VSMMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)loadedVersion));
            }
            if (migrationIsNeeded) {
                VSMExtendedMetaData extendedMetaData = new VSMExtendedMetaData(loadedVersion);
                VSMResourceHandler resourceHandler = new VSMResourceHandler(loadedVersion);
                HashMap<String, Object> loadOptions = new HashMap<String, Object>();
                loadOptions.put("EXTENDED_META_DATA", extendedMetaData);
                loadOptions.put("RESOURCE_HANDLER", resourceHandler);
                ((DescriptionResourceImpl)resource).getDefaultLoadOptions().putAll(loadOptions);
                HashMap<String, Object> saveOptions = new HashMap<String, Object>();
                saveOptions.put("EXTENDED_META_DATA", extendedMetaData);
                saveOptions.put("RESOURCE_HANDLER", resourceHandler);
                ((DescriptionResourceImpl)resource).getDefaultSaveOptions().putAll(saveOptions);
            }
        }
    }
}

