/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import java.util.regex.Pattern;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.properties.ui.api.AbstractEEFTabbedPropertySheetPageContributorWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.eclipse.sirius.ui.properties.internal.SiriusInputDescriptor;
import org.eclipse.ui.forms.widgets.Form;

public class ContributorWrapper
extends AbstractEEFTabbedPropertySheetPageContributorWrapper {
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r\n|\r|\n|\u2028");

    public ContributorWrapper(Object realContributor, String contributorId) {
        super(realContributor, contributorId);
    }

    public void updateFormTitle(Form form, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object element = structuredSelection.getFirstElement();
            if (element == null) {
                return;
            }
            SiriusInputDescriptor inputDescriptor = new SiriusInputDescriptor(element);
            EObject semanticElement = inputDescriptor.getSemanticElement();
            if (semanticElement != null) {
                String text = new EditingDomainServices().getLabelProviderText(semanticElement);
                if (!Util.isBlank((String)text)) {
                    String[] result = LINE_SEPARATOR_PATTERN.split(text, 2);
                    if (result.length >= 1) {
                        form.setText(result[0]);
                    }
                } else {
                    form.setText("");
                }
                form.setImage(ExtendedImageRegistry.INSTANCE.getImage(new EditingDomainServices().getLabelProviderImage(semanticElement)));
            } else {
                form.setText("");
                form.setImage(null);
            }
        }
    }
}

