/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.api.AbstractEEFEclipsePlugin;
import org.eclipse.eef.ide.api.extensions.AbstractRegistryEventListener;
import org.eclipse.eef.ide.api.extensions.IItemDescriptor;
import org.eclipse.eef.ide.api.extensions.IItemRegistry;
import org.eclipse.eef.ide.api.extensions.impl.DescriptorRegistryEventListener;
import org.eclipse.eef.ide.api.extensions.impl.ItemRegistry;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.ui.properties.api.DefaultDescriptionConverter;
import org.eclipse.sirius.ui.properties.api.DefaultDescriptionWithInitialOperationConverter;
import org.eclipse.sirius.ui.properties.api.IDescriptionConverter;
import org.eclipse.sirius.ui.properties.api.IDescriptionLinkResolver;
import org.eclipse.sirius.ui.properties.internal.tabprovider.PropertiesDescriptionConverterSwitch;
import org.eclipse.sirius.ui.properties.internal.tabprovider.PropertyValidationRuleLinkResolver;
import org.eclipse.sirius.ui.properties.internal.tabprovider.SemanticValidationRuleDescriptionConverter;
import org.eclipse.sirius.viewpoint.description.validation.RuleAudit;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class SiriusUIPropertiesPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.sirius.ui.properties";
    public static final SiriusUIPropertiesPlugin INSTANCE = new SiriusUIPropertiesPlugin();
    private static Implementation plugin;

    public SiriusUIPropertiesPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends AbstractEEFEclipsePlugin {
        private static final String DESCRIPTION_CONVERTER_EXTENSION_POINT = "descriptionConverter";
        private static final String DESCRIPTION_LINK_RESOLVER_EXTENSION_POINT = "descriptionLinkResolver";
        private IItemRegistry<IDescriptionConverter> descriptionConverterRegistry;
        private IItemRegistry<IDescriptionLinkResolver> descriptionLinkResolverRegistry;
        private AbstractRegistryEventListener descriptionConverterListener;
        private AbstractRegistryEventListener descriptionLinkResolverListener;
        private ScopedPreferenceStore preferenceStore;
        private IPropertyChangeListener propertyChangeListener;

        public Implementation() {
            super(SiriusUIPropertiesPlugin.PLUGIN_ID);
            plugin = this;
            this.startPropertiesPreferencesManagement();
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            this.descriptionConverterRegistry = new ItemRegistry();
            this.descriptionConverterListener = new DescriptorRegistryEventListener(SiriusUIPropertiesPlugin.PLUGIN_ID, DESCRIPTION_CONVERTER_EXTENSION_POINT, this.descriptionConverterRegistry);
            registry.addListener((IRegistryEventListener)this.descriptionConverterListener, "org.eclipse.sirius.ui.properties.descriptionConverter");
            this.descriptionConverterListener.readRegistry(registry);
            this.descriptionLinkResolverRegistry = new ItemRegistry();
            this.descriptionLinkResolverListener = new DescriptorRegistryEventListener(SiriusUIPropertiesPlugin.PLUGIN_ID, DESCRIPTION_LINK_RESOLVER_EXTENSION_POINT, this.descriptionLinkResolverRegistry);
            registry.addListener((IRegistryEventListener)this.descriptionLinkResolverListener, "org.eclipse.sirius.ui.properties.descriptionLinkResolver");
            this.descriptionLinkResolverListener.readRegistry(registry);
        }

        public void stop(BundleContext context) throws Exception {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.descriptionConverterListener);
            registry.removeListener((IRegistryEventListener)this.descriptionLinkResolverListener);
            this.descriptionConverterListener = null;
            this.descriptionConverterRegistry = null;
            this.descriptionLinkResolverListener = null;
            this.descriptionLinkResolverRegistry = null;
            this.stopPropertiesPreferencesManagement();
            super.stop(context);
        }

        public IDescriptionConverter getDescriptionConverter(EObject description) {
            IDescriptionConverter converter = null;
            List itemDescriptors = this.descriptionConverterRegistry.getItemDescriptors();
            for (IItemDescriptor itemDescriptor : itemDescriptors) {
                IDescriptionConverter descriptionConverter = (IDescriptionConverter)itemDescriptor.getItem();
                if (!descriptionConverter.canHandle(description)) continue;
                converter = descriptionConverter;
                break;
            }
            if (converter == null) {
                if (description instanceof SemanticValidationRule) {
                    converter = new SemanticValidationRuleDescriptionConverter();
                } else if (description instanceof RuleAudit) {
                    converter = new DefaultDescriptionConverter<RuleAudit>(RuleAudit.class, EefPackage.Literals.EEF_RULE_AUDIT_DESCRIPTION);
                } else if (description instanceof ValidationFix) {
                    converter = new DefaultDescriptionWithInitialOperationConverter<ValidationFix>(ValidationFix.class, EefPackage.Literals.EEF_VALIDATION_FIX_DESCRIPTION, EefPackage.Literals.EEF_VALIDATION_FIX_DESCRIPTION__FIX_EXPRESSION);
                } else {
                    PropertiesDescriptionConverterSwitch descriptionConverterSwitch = new PropertiesDescriptionConverterSwitch();
                    converter = (IDescriptionConverter)descriptionConverterSwitch.doSwitch(description);
                }
            }
            return converter;
        }

        public List<IDescriptionLinkResolver> getDescriptionLinkResolvers() {
            ArrayList<IDescriptionLinkResolver> linkResolvers = new ArrayList<IDescriptionLinkResolver>();
            linkResolvers.add(new PropertyValidationRuleLinkResolver());
            List itemDescriptors = this.descriptionLinkResolverRegistry.getItemDescriptors();
            for (IItemDescriptor itemDescriptor : itemDescriptors) {
                IDescriptionLinkResolver linkResolver = (IDescriptionLinkResolver)itemDescriptor.getItem();
                linkResolvers.add(linkResolver);
            }
            return linkResolvers;
        }

        private void startPropertiesPreferencesManagement() {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    Object newValue = event.getNewValue();
                    Implementation.this.preferenceStore.putValue(event.getProperty(), String.valueOf(newValue));
                }
            };
            this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }

        private void stopPropertiesPreferencesManagement() {
            this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }

        public IPreferenceStore getPreferenceStore() {
            if (this.preferenceStore == null) {
                this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, INSTANCE.getSymbolicName());
            }
            return this.preferenceStore;
        }
    }
}

