/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.logger.RuntimeLogger;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.logger.RuntimeLoggerManagerImpl;
import org.eclipse.sirius.tools.internal.ui.RefreshHelper;
import org.eclipse.sirius.ui.properties.internal.Messages;

public class TransactionalEditingDomainContextAdapter
implements EditingContextAdapter {
    private static final String FORCE_REFRESH_SYSTEM_FLAG = "org.eclipse.sirius.properties.forceRefreshOnRepresentationsChange";
    private static final NotificationFilter FILTER = NotificationFilter.NOT_TOUCH.and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    private final TransactionalEditingDomain ted;
    private final ResourceSetListener preCommitListener = new Listener();
    private IConsumer<List<Notification>> callback;
    private RuntimeLoggerSpy spy = new RuntimeLoggerSpy(RuntimeLoggerManager.INSTANCE);

    public TransactionalEditingDomainContextAdapter(TransactionalEditingDomain ted) {
        this.ted = (TransactionalEditingDomain)Preconditions.checkNotNull((Object)ted);
    }

    public IStatus performModelChange(final Runnable effect) {
        IStatus result;
        block6: {
            RecordingCommand cmd = new RecordingCommand(this.ted){

                protected void doExecute() {
                    effect.run();
                }
            };
            result = Status.OK_STATUS;
            this.spy.enable();
            try {
                try {
                    this.ted.getCommandStack().execute((Command)cmd);
                    if (!this.spy.hasSeenErrors()) break block6;
                    IStatus[] errors = this.spy.getErrors();
                    if (errors.length > 1) {
                        result = new MultiStatus("org.eclipse.sirius.ui.properties", 0, errors, Messages.TransactionalEditingDomainContextAdapter_errorDuringCommand, null);
                        break block6;
                    }
                    result = errors[0];
                }
                catch (Throwable th) {
                    result = new Status(4, "org.eclipse.sirius.ui.properties", Messages.TransactionalEditingDomainContextAdapter_errorDuringCommand, th);
                    this.spy.disable();
                }
            }
            finally {
                this.spy.disable();
            }
        }
        return result;
    }

    public synchronized void onModelChange(IConsumer<List<Notification>> trigger) {
        if (this.callback == null) {
            this.ted.addResourceSetListener(this.preCommitListener);
        }
        this.callback = trigger;
    }

    public void removeModelChangeConsumer() {
        this.callback = null;
        this.ted.removeResourceSetListener(this.preCommitListener);
    }

    public EditingDomain getEditingDomain() {
        return this.ted;
    }

    private static boolean forceRefreshOnRepresentationChanges() {
        return Boolean.TRUE.toString().equals(System.getProperty(FORCE_REFRESH_SYSTEM_FLAG, Boolean.FALSE.toString()));
    }

    private static boolean containsSemanticModelChanges(List<Notification> changes) {
        return RefreshHelper.isImpactingNotification(changes);
    }

    private class Listener
    extends ResourceSetListenerImpl {
        public Listener() {
            super(FILTER);
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            IConsumer t = TransactionalEditingDomainContextAdapter.this.callback;
            if (t != null && (TransactionalEditingDomainContextAdapter.forceRefreshOnRepresentationChanges() || TransactionalEditingDomainContextAdapter.containsSemanticModelChanges(event.getNotifications()))) {
                t.apply((Object)Lists.newArrayList((Iterable)event.getNotifications()));
            }
        }
    }

    private static final class RuntimeLoggerSpy
    implements RuntimeLogger {
        private final List<IStatus> errors = new ArrayList<IStatus>();
        private RuntimeLoggerManager manager;

        public RuntimeLoggerSpy(RuntimeLoggerManager instance) {
            this.manager = instance;
        }

        public void enable() {
            if (this.manager instanceof RuntimeLoggerManagerImpl) {
                ((RuntimeLoggerManagerImpl)this.manager).add((RuntimeLogger)this);
            }
        }

        public void disable() {
            if (this.manager instanceof RuntimeLoggerManagerImpl) {
                ((RuntimeLoggerManagerImpl)this.manager).remove((RuntimeLogger)this);
            }
            this.errors.clear();
        }

        public boolean hasSeenErrors() {
            return !this.errors.isEmpty();
        }

        public IStatus[] getErrors() {
            return this.errors.toArray(new IStatus[this.errors.size()]);
        }

        public void info(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        }

        public void info(EObject odesignObject, EStructuralFeature feature, String message) {
        }

        public void warning(EObject odesignObject, EStructuralFeature feature, String message) {
        }

        public void warning(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        }

        public void error(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
            this.errors.add((IStatus)new Status(4, "org.eclipse.sirius.ui.properties", exception.getMessage(), exception));
        }

        public void error(EObject odesignObject, EStructuralFeature feature, String message) {
            this.errors.add((IStatus)new Status(4, "org.eclipse.sirius.ui.properties", message));
        }

        public void clearAll() {
        }

        public void clear(EObject eObject) {
        }
    }
}

