/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.expressions;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.properties.CustomExpression;
import org.eclipse.sirius.properties.CustomOperation;
import org.eclipse.sirius.properties.DynamicMappingFor;
import org.eclipse.sirius.properties.DynamicMappingIf;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.GroupStyle;
import org.eclipse.sirius.properties.OperationDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.WidgetAction;
import org.eclipse.sirius.properties.WidgetConditionalStyle;
import org.eclipse.sirius.properties.WidgetDescription;
import org.eclipse.sirius.properties.WidgetStyle;
import org.eclipse.sirius.properties.util.PropertiesSwitch;
import org.eclipse.sirius.ui.properties.internal.expressions.VSMNavigation;

public class DomainClassSwitch
extends PropertiesSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected EStructuralFeature feature;
    protected boolean considerFeature;

    public DomainClassSwitch(EStructuralFeature feature) {
        this.feature = feature;
    }

    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        LinkedHashSet defaultResult = Sets.newLinkedHashSet();
        return Options.newSome((Object)defaultResult);
    }

    public void setConsiderFeature(boolean considerFeature) {
        this.considerFeature = considerFeature;
    }

    public Option<Collection<String>> casePageDescription(PageDescription page) {
        Option result = null;
        switch (this.getFeatureId(page.eClass())) {
            case 3: {
                LinkedHashSet target = Sets.newLinkedHashSet();
                target.add(TypeName.EOBJECT_TYPENAME.getCompleteName());
                result = Options.newSome((Object)target);
                break;
            }
            case -1: 
            case 1: 
            case 4: {
                result = Options.newSome(VSMNavigation.getPageDomainClass(page));
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseGroupDescription(GroupDescription group) {
        Option result = null;
        switch (this.getFeatureId(group.eClass())) {
            case 3: {
                LinkedHashSet target = Sets.newLinkedHashSet();
                for (PageDescription page : VSMNavigation.findReferencingPages(group)) {
                    target.addAll(VSMNavigation.getPageDomainClass(page));
                }
                result = Options.newSome((Object)target);
                break;
            }
            case -1: 
            case 1: 
            case 4: {
                result = Options.newSome(VSMNavigation.getGroupDomainClass(group));
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseWidgetDescription(WidgetDescription object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseWidgetStyle(WidgetStyle object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseWidgetConditionalStyle(WidgetConditionalStyle object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseWidgetAction(WidgetAction object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseGroupStyle(GroupStyle object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseCustomExpression(CustomExpression object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseCustomOperation(CustomOperation object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseOperationDescription(OperationDescription object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseDynamicMappingFor(DynamicMappingFor object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseDynamicMappingIf(DynamicMappingIf object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    private int getFeatureId(EClass eClass) {
        if (this.considerFeature && this.feature != null) {
            return eClass.getFeatureID(this.feature);
        }
        return -1;
    }
}

