/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.tabprovider;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFPageDescription;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.EefFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.ui.properties.api.DescriptionCache;
import org.eclipse.sirius.ui.properties.api.IDescriptionConverter;
import org.eclipse.sirius.ui.properties.api.IDescriptionLinkResolver;
import org.eclipse.sirius.ui.properties.internal.SiriusInputDescriptor;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;

public class ViewDescriptionConverter {
    private final List<PageDescription> pageDescriptions;

    public ViewDescriptionConverter(List<PageDescription> pageDescriptions) {
        this.pageDescriptions = pageDescriptions;
    }

    public EEFViewDescription convert(SiriusInputDescriptor input) {
        EEFViewDescription view = this.createView();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("input", input);
        parameters.put("view", view);
        DescriptionCache cache = new DescriptionCache();
        for (PageDescription pageDescription : this.pageDescriptions) {
            IDescriptionConverter converter = SiriusUIPropertiesPlugin.getPlugin().getDescriptionConverter((EObject)pageDescription);
            EObject page = converter.convert((EObject)pageDescription, parameters, cache);
            if (!(page instanceof EEFPageDescription)) continue;
            view.getPages().add((Object)((EEFPageDescription)page));
            for (GroupDescription groupDescription : pageDescription.getGroups()) {
                if (!cache.getAllSiriusDescriptions().contains(groupDescription)) {
                    IDescriptionConverter groupConverter = SiriusUIPropertiesPlugin.getPlugin().getDescriptionConverter((EObject)groupDescription);
                    EObject group = groupConverter.convert((EObject)groupDescription, parameters, cache);
                    if (!(group instanceof EEFGroupDescription)) continue;
                    view.getGroups().add((Object)((EEFGroupDescription)group));
                    ((EEFPageDescription)page).getGroups().add((Object)((EEFGroupDescription)group));
                    continue;
                }
                ((EEFPageDescription)page).getGroups().add((Object)((EEFGroupDescription)cache.getEEFDescription(groupDescription)));
            }
        }
        List<IDescriptionLinkResolver> linkResolvers = SiriusUIPropertiesPlugin.getPlugin().getDescriptionLinkResolvers();
        for (IDescriptionLinkResolver linkResolver : linkResolvers) {
            linkResolver.resolve(view, cache);
        }
        return view;
    }

    private EEFViewDescription createView() {
        EEFViewDescription view = EefFactory.eINSTANCE.createEEFViewDescription();
        view.setLabelExpression("aql:input.emfEditServices(self).getText()");
        view.setImageExpression("aql:input.emfEditServices(self).getImage()");
        LinkedHashSet ePackages = new LinkedHashSet();
        for (PageDescription pageDescription : this.pageDescriptions) {
            EObject eContainer = pageDescription.eContainer();
            if (!(eContainer instanceof ViewExtensionDescription)) continue;
            ViewExtensionDescription viewExtensionDescription = (ViewExtensionDescription)eContainer;
            ePackages.addAll(viewExtensionDescription.getMetamodels());
        }
        view.getEPackages().addAll(ePackages);
        return view;
    }
}

