/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.deploy;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.DateUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.runtime.DeployedModelDescription;
import org.eclipse.stardust.engine.core.compatibility.gui.utils.DateEntry;
import org.eclipse.stardust.modeling.deploy.Deploy_Messages;

public class DeployedModelsView
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int DEPLOYMENT_MODE = 0;
    public static final int ADMINISTRATION_MODE = 1;
    public static final int SELECTION_MODE = 2;
    private boolean overwrite;
    private List<ModelTemplate> deployments;
    private JRadioButton oneYear;
    private JRadioButton twoYears;
    private JRadioButton fullScale;
    private JList list;
    private DateEntry validFromEntry;
    private JTextArea commentEntry;
    private long now;
    private long start;
    private long end;
    private List<ModelTemplate> templates = Collections.emptyList();
    private Map<Segment, ModelTemplate> segments = CollectionUtils.newMap();
    private Action oneYearAction = new AbstractAction(Deploy_Messages.getString("MSG_ONE_YEAR")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DeployedModelsView.this.set1YearScale();
            DeployedModelsView.this.list.repaint();
        }
    };
    private Action twoYearsAction = new AbstractAction(Deploy_Messages.getString("MSG_TWO_YEARS")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Calendar now = Calendar.getInstance();
            Calendar start = (Calendar)now.clone();
            start.add(2, -4);
            Calendar end = (Calendar)now.clone();
            end.add(2, 20);
            DeployedModelsView.this.now = now.getTime().getTime();
            DeployedModelsView.this.start = start.getTime().getTime();
            DeployedModelsView.this.end = end.getTime().getTime();
            DeployedModelsView.this.list.repaint();
        }
    };
    private Action fullScaleAction = new AbstractAction(Deploy_Messages.getString("MSG_ALL")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent event) {
            Calendar now = Calendar.getInstance();
            long n = now.getTime().getTime();
            long s = Long.MAX_VALUE;
            long e = Long.MIN_VALUE;
            boolean set = false;
            for (ModelTemplate template : DeployedModelsView.this.templates) {
                Date d = template.validFrom;
                if (d == null || s < d.getTime()) continue;
                s = d.getTime();
                set = true;
            }
            if (set) {
                long ds = n - s;
                long es = e - n;
                if (ds < es) {
                    ds = es;
                }
                DeployedModelsView.this.now = n;
                DeployedModelsView.this.start = n - (ds += 604800000L);
                DeployedModelsView.this.end = n + ds;
                DeployedModelsView.this.list.repaint();
            }
        }
    };
    private ListSelectionListener listener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!DeployedModelsView.this.overwrite) {
                DeployedModelsView.this.list.setSelectedValue(DeployedModelsView.this.deployments.get(0), false);
            } else if (e != null && DeployedModelsView.this.list.getSelectedIndex() == -1) {
                DeployedModelsView.this.list.setSelectedIndex(e.getFirstIndex());
            }
        }
    };
    private InputVerifier detailsVerifier = new InputVerifier(){
        boolean inMessage = false;

        @Override
        public boolean verify(JComponent input) {
            if (this.inMessage) {
                return false;
            }
            Date from = DeployedModelsView.this.validFromEntry.getDate();
            for (ModelTemplate m : DeployedModelsView.this.deployments) {
                m.validFrom = from;
            }
            DeployedModelsView.this.computeSegments();
            DeployedModelsView.this.list.repaint();
            return true;
        }
    };

    public DeployedModelsView() {
        this.setLayout(new BorderLayout());
        JToolBar buttons = new JToolBar();
        buttons.setFloatable(false);
        buttons.setBorderPainted(false);
        this.oneYear = new JRadioButton(this.oneYearAction);
        this.twoYears = new JRadioButton(this.twoYearsAction);
        this.fullScale = new JRadioButton(this.fullScaleAction);
        ButtonGroup group = new ButtonGroup();
        group.add(this.oneYear);
        group.add(this.twoYears);
        group.add(this.fullScale);
        this.oneYear.setSelected(true);
        buttons.add(new JLabel(Deploy_Messages.getString("LB_SCALE")));
        buttons.add(this.oneYear);
        buttons.add(this.twoYears);
        buttons.add(this.fullScale);
        this.add((Component)buttons, "North");
        this.set1YearScale();
        this.list = new JList(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                double w = this.getSize().getWidth();
                double scale = w / (double)(DeployedModelsView.this.end - DeployedModelsView.this.start);
                g.setColor(Color.black);
                int n = (int)(scale * (double)(DeployedModelsView.this.now - DeployedModelsView.this.start));
                g.drawLine(n, 0, n, this.getSize().height);
            }
        };
        this.list.setCellRenderer(new TimeFrameRenderer());
        this.list.setSelectionMode(0);
        JScrollPane scroller = new JScrollPane(this.list);
        scroller.setPreferredSize(new Dimension(400, 200));
        this.add(scroller);
        this.validFromEntry = new DateEntry();
        this.commentEntry = new JTextArea(5, 15);
        this.validFromEntry.setInputVerifier(this.detailsVerifier);
        this.commentEntry.setInputVerifier(this.detailsVerifier);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, default, 4dlu, default", "default, 4dlu, default, 4dlu, default, 4dlu, default, default, default");
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add((Component)new JLabel(Deploy_Messages.getString("LBL_VALID_FROM")), cc.xy(2, 1));
        panel.add((Component)this.validFromEntry, cc.xy(4, 1));
        panel.add((Component)new JLabel(Deploy_Messages.getString("LBL_DEPLOYMENT_COMMENT")), cc.xy(2, 3));
        panel.add((Component)new JScrollPane(this.commentEntry), cc.xywh(2, 5, 3, 1));
        this.add((Component)panel, "East");
        this.list.addListSelectionListener(this.listener);
    }

    private void set1YearScale() {
        Calendar now = Calendar.getInstance();
        Calendar start = (Calendar)now.clone();
        start.add(2, -2);
        Calendar end = (Calendar)now.clone();
        end.add(2, 10);
        this.now = now.getTime().getTime();
        this.start = start.getTime().getTime();
        this.end = end.getTime().getTime();
    }

    public void setData(List<DeployedModelDescription> descriptions, List<IModel> models, boolean overwrite) {
        this.overwrite = overwrite;
        ModelTemplate selection = null;
        this.templates = CollectionUtils.newList((int)(descriptions.size() + models.size()));
        this.deployments = CollectionUtils.newList((int)models.size());
        for (IModel model : models) {
            ModelTemplate deployment = new ModelTemplate(model);
            this.deployments.add(deployment);
            if (overwrite) continue;
            this.templates.add(deployment);
            if (!this.deployments.isEmpty()) continue;
            selection = deployment;
        }
        IModel firstModel = models.get(0);
        int i = 0;
        while (i < descriptions.size()) {
            DeployedModelDescription description = descriptions.get(i);
            ModelTemplate template = new ModelTemplate(description);
            if (!overwrite || template.id.equals(firstModel.getId())) {
                this.templates.add(template);
            }
            if (overwrite && template.modelOID == firstModel.getModelOID()) {
                selection = template;
            }
            ++i;
        }
        if (selection == null) {
            selection = this.deployments.get(0);
        }
        this.validFromEntry.setDate(selection.validFrom);
        this.commentEntry.setText(selection.comment);
        this.initialize(selection);
    }

    private void initialize(ModelTemplate selection) {
        this.computeSegments();
        DefaultListModel<ModelTemplate> listModel = new DefaultListModel<ModelTemplate>();
        for (ModelTemplate template : this.templates) {
            listModel.addElement(template);
        }
        this.list.setModel(listModel);
        this.list.setSelectedValue(selection, true);
        this.listener.valueChanged(null);
        this.set1YearScale();
    }

    private void computeSegments() {
        ArrayList list = CollectionUtils.newArrayList();
        for (ModelTemplate m : this.templates) {
            Long ts = new Long(DateUtils.getTimestamp((Date)m.validFrom, (long)Long.MIN_VALUE));
            if (!list.contains(ts)) {
                list.add(ts);
            }
            if (list.contains(ts = Long.valueOf(Long.MAX_VALUE))) continue;
            list.add(ts);
        }
        Collections.sort(list);
        this.segments.clear();
        int i = 0;
        while (i < list.size() - 1) {
            Segment s = new Segment((Long)list.get(i), (Long)list.get(i + 1));
            for (ModelTemplate m : this.templates) {
                long ts = DateUtils.getTimestamp((Date)m.validFrom, (long)Long.MIN_VALUE);
                long es = Long.MAX_VALUE;
                if (ts > s.start || es < s.end) continue;
                this.segments.put(s, m);
                break;
            }
            ++i;
        }
    }

    public Date getValidFrom() {
        return this.validFromEntry.getDate();
    }

    public String getComment() {
        return this.commentEntry.getText();
    }

    public int getSelectedModelOID() {
        ModelTemplate template = (ModelTemplate)this.list.getSelectedValue();
        return template == null ? -1 : template.modelOID;
    }

    private class ModelTemplate {
        private int modelOID;
        private String name;
        private Date validFrom;
        private String comment;
        private String id;

        private ModelTemplate(Object source) {
            if (source instanceof DeployedModelDescription) {
                this.set((DeployedModelDescription)source);
            } else if (source instanceof IModel) {
                this.set((IModel)source);
            }
        }

        private void set(DeployedModelDescription md) {
            this.modelOID = md.getModelOID();
            this.id = md.getId();
            this.name = MessageFormat.format(Deploy_Messages.getString("LBL_NAME_VERSION_OID"), md.getName(), md.getVersion(), this.modelOID);
            this.validFrom = md.getValidFrom();
            this.comment = md.getDeploymentComment();
        }

        private void set(IModel md) {
            this.modelOID = md.getModelOID();
            this.id = md.getId();
            String version = (String)md.getAttribute("carnot:engine:version");
            this.name = this.modelOID == 0 ? MessageFormat.format(Deploy_Messages.getString("LBL_NAME_VERSION"), md.getName(), version) : MessageFormat.format(Deploy_Messages.getString("LBL_NAME_VERSION_OID"), md.getName(), version, this.modelOID);
            this.validFrom = (Date)md.getAttribute("carnot:engine:validFrom");
            this.comment = (String)md.getAttribute("carnot:engine:deploymentComment");
        }
    }

    private static class Segment {
        long start;
        long end;

        public Segment(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }

    private class TimeFrameRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color Active = new Color(0.0f, 0.7f, 0.0f);
        private ModelTemplate current;
        private Border border = BorderFactory.createEmptyBorder(1, 1, 8, 1);
        private Font bold;

        private TimeFrameRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            double w = this.getSize().getWidth();
            int h = this.getSize().height - 8;
            double scale = w / (double)(DeployedModelsView.this.end - DeployedModelsView.this.start);
            int s = (int)(this.current.validFrom == null ? -1.0 : scale * (double)(this.current.validFrom.getTime() - DeployedModelsView.this.start));
            int e = (int)(w + 1.0);
            g.setColor(this.Active);
            g.drawLine(s, h, e, h);
            for (Map.Entry entry : DeployedModelsView.this.segments.entrySet()) {
                if (entry.getValue() != this.current) continue;
                Segment seg = (Segment)entry.getKey();
                int s1 = seg.start <= DeployedModelsView.this.start ? s : (int)(scale * (double)(seg.start - DeployedModelsView.this.start));
                int e1 = seg.end >= DeployedModelsView.this.end ? e : (int)(scale * (double)(seg.end - DeployedModelsView.this.start));
                g.drawLine(s1, h - 1, e1, h - 1);
                g.drawLine(s1, h, e1, h);
                g.drawLine(s1, h + 1, e1, h + 1);
            }
            g.setColor(Color.black);
            g.drawLine(s, h - 3, s, h + 3);
            g.drawLine(e, h - 3, e, h + 3);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.current = isSelected && DeployedModelsView.this.overwrite ? (ModelTemplate)DeployedModelsView.this.deployments.get(0) : (ModelTemplate)value;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setOpaque(isSelected);
            StringBuffer text = new StringBuffer();
            text.append(' ');
            text.append(this.current.name);
            text.append(": ");
            text.append(DateUtils.formatDate((Date)this.current.validFrom));
            this.setText(text.toString());
            if (DeployedModelsView.this.deployments.contains(this.current)) {
                this.setEnabled(true);
                this.setForeground(Color.red);
                this.setFont(this.bold == null ? (this.bold = this.getFont().deriveFont(1)) : this.bold);
            }
            this.setBorder(this.border);
            return this;
        }
    }
}

