/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.spring.application;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class SpringBeanValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        List result = CollectionUtils.newList();
        String beanId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:spring::beanId");
        if (StringUtils.isEmpty((String)beanId)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_NoBeanId, (Object)"carnot:engine:spring::beanId"));
        }
        TypeFinder typeFinder = new TypeFinder((EObject)element);
        TypeInfo type = null;
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_JavaClassNotSpecified, (Object)"carnot:engine:className"));
        } else {
            ModelType model = ModelUtils.findContainingModel((EObject)element);
            VariableContext variableContext = VariableContextHelper.getInstance().getContext(model);
            className = variableContext.replaceAllVariablesByDefaultValue(className);
            type = typeFinder.findType(className);
            if (type == null) {
                result.add(Issue.error((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), (Object)"carnot:engine:className"));
            } else {
                String method = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
                if (StringUtils.isEmpty((String)method)) {
                    result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_CompletionMethodNotSpecified, (Object)"carnot:engine:methodName"));
                } else {
                    MethodInfo info = typeFinder.getMethod(type, method);
                    if (info == null) {
                        result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_CantFindMethodInClass, method, type.getType().getElementName()), (Object)"carnot:engine:methodName"));
                    } else if (!info.isAccessible()) {
                        result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_MethodNotVisible, method, type.getType().getElementName()), (Object)"carnot:engine:methodName"));
                    }
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

