/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;

public class JSClassLoader
extends ClassLoader {
    private IJavaProject javaProject;
    private static final String PROTOCAL_PREFIX = "file:///";

    public JSClassLoader(IJavaProject project) {
        if (project == null || !project.exists() || !project.isOpen()) {
            throw new IllegalArgumentException("Invalid javaProject");
        }
        this.javaProject = project;
    }

    public Class findClass(String className) {
        try {
            String[] classPaths = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this.javaProject);
            URL[] urls = new URL[classPaths.length];
            int i = 0;
            while (i < classPaths.length) {
                urls[i] = new URL(PROTOCAL_PREFIX + JSClassLoader.computeForURLClassLoader(classPaths[i]));
                ++i;
            }
            URLClassLoader loader = new URLClassLoader(urls);
            Class<?> classObject = loader.loadClass(className);
            return classObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String computeForURLClassLoader(String classpath) {
        File file;
        if (!classpath.endsWith("/") && (file = new File(classpath)).exists() && file.isDirectory()) {
            classpath = classpath.concat("/");
        }
        return classpath;
    }
}

