/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ImportPlugin;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.elements.ImportModelElementsWizardPage;
import org.eclipse.stardust.modeling.modelimport.elements.MergeEditorInput;
import org.eclipse.stardust.modeling.modelimport.elements.MergeModelElementsWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;

public class ImportModelElementsWizard
extends Wizard
implements IImportWizard {
    private ImportModelElementsWizardPage importModelElementsWizardPage;
    private MergeModelElementsWizardPage mergeModelElementsWizardPage;

    public ImportModelElementsWizard() {
        this.setWindowTitle(Import_Messages.DESC_CarnotFileImport);
    }

    public boolean performFinish() {
        return ((IImportModelWizardPage)this.getContainer().getCurrentPage()).performFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        WorkflowModelEditor wme;
        ModelType model_;
        URI modelURI;
        ImportPlugin.resetExtensions();
        List<IFile> selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        Object selection = selectedResources.isEmpty() ? currentSelection.getFirstElement() : selectedResources.get(0);
        IEditorPart editorPart = null;
        if (currentSelection.getFirstElement() instanceof IEditorPart) {
            editorPart = (IEditorPart)currentSelection.getFirstElement();
        }
        if (editorPart instanceof WorkflowModelEditor && (modelURI = (model_ = (wme = (WorkflowModelEditor)editorPart).getWorkflowModel()).eResource().getURI()).isPlatformResource()) {
            Path path = new Path(modelURI.toPlatformString(true));
            IFile modelResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (selectedResources.isEmpty() || modelResource.equals(selectedResources.get(0))) {
                selection = wme.getModelManager();
                selectedResources = Collections.singletonList(modelResource);
            }
        }
        if (selectedResources.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Import_Messages.MSG_InvalidSel, (String)Import_Messages.MSG_SelectModel);
        } else {
            this.importModelElementsWizardPage = new ImportModelElementsWizardPage(Import_Messages.LB_ElementsImport, selection);
            this.mergeModelElementsWizardPage = new MergeModelElementsWizardPage("merge", this.importModelElementsWizardPage);
            final WorkflowModelManager target = this.importModelElementsWizardPage.getTarget();
            if (target != null && target.getModel() == null) {
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                    IRunnableWithProgress loader = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            MergeEditorInput.load(monitor, target, target.toString());
                        }
                    };
                    dialog.run(false, true, loader);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.importModelElementsWizardPage);
        this.addPage((IWizardPage)this.mergeModelElementsWizardPage);
    }
}

