/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.refactoring.RefactoringUtils;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.AttributeValueChange;

public class DataOperator
implements IJdtOperator {
    private String typeId;
    private String[] names;

    public DataOperator(String type, String[] attributes) {
        this.typeId = type;
        this.names = attributes;
    }

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        if (!(element instanceof IType) && !(element instanceof IPackageFragment)) {
            return Collections.EMPTY_LIST;
        }
        String originalPackageName = null;
        String newPackageName = null;
        if (element instanceof IPackageFragment) {
            originalPackageName = ((IPackageFragment)element).getElementName();
            newPackageName = OperatorsRegistry.getNewPackageName((IPackageFragment)element, arguments);
            if (newPackageName.equals(originalPackageName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalClassName = null;
        String newClassName = null;
        if (element instanceof IType) {
            originalClassName = ((IType)element).getFullyQualifiedName();
            newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
            if (newClassName.equals(originalClassName)) {
                return Collections.EMPTY_LIST;
            }
        }
        if (newPackageName == null && newClassName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AttributeValueChange> result = new ArrayList<AttributeValueChange>();
        EList dataTypes = model.getDataType();
        int i = 0;
        while (i < dataTypes.size()) {
            DataTypeType type = (DataTypeType)dataTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList serializables = type.getData();
                int j = 0;
                while (j < serializables.size()) {
                    DataType data = (DataType)serializables.get(j);
                    int k = 0;
                    while (k < this.names.length) {
                        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)this.names[k]);
                        if (attribute != null) {
                            if (element instanceof IPackageFragment) {
                                String className = attribute.getValue();
                                if (RefactoringUtils.containsPackage(className, originalPackageName)) {
                                    result.add(new AttributeValueChange(attribute, RefactoringUtils.getNewClassName(className, originalPackageName, newPackageName)));
                                }
                            } else if (element instanceof IType && originalClassName.equals(attribute.getValue())) {
                                result.add(new AttributeValueChange(attribute, newClassName));
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        if (!(element instanceof IType) && !(element instanceof IPackageFragment)) {
            return Collections.EMPTY_LIST;
        }
        String packageName = null;
        if (element instanceof IPackageFragment) {
            packageName = ((IPackageFragment)element).getElementName();
        }
        String className = null;
        if (element instanceof IType) {
            className = ((IType)element).getFullyQualifiedName();
        }
        if (packageName == null && className == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EObjectMatch> result = new ArrayList<EObjectMatch>();
        EList dataTypes = model.getDataType();
        int i = 0;
        while (i < dataTypes.size()) {
            DataTypeType type = (DataTypeType)dataTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList serializables = type.getData();
                int j = 0;
                while (j < serializables.size()) {
                    DataType data = (DataType)serializables.get(j);
                    int k = 0;
                    while (k < this.names.length) {
                        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)this.names[k]);
                        if (attribute != null && !(element instanceof IPackageFragment) && element instanceof IType && className.equals(attribute.getValue())) {
                            result.add(new EObjectMatch(file, attribute, 0, className.length()));
                        }
                        ++k;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }
}

