/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.refactoring.RefactoringUtils;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.AttributeValueChange;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.EObjectStringValueSubstituteChange;

public class TriggerOperator
implements IJdtOperator {
    private String typeId;

    public TriggerOperator(String id) {
        this.typeId = id;
    }

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        String originalPackageName = null;
        String newPackageName = null;
        if (element instanceof IPackageFragment) {
            originalPackageName = ((IPackageFragment)element).getElementName();
            newPackageName = OperatorsRegistry.getNewPackageName((IPackageFragment)element, arguments);
            if (newPackageName.equals(originalPackageName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalClassName = null;
        String newClassName = null;
        if (element instanceof IType) {
            originalClassName = ((IType)element).getFullyQualifiedName();
            newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
            if (newClassName.equals(originalClassName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalMethodName = null;
        String newMethodName = null;
        if (element instanceof IMethod) {
            originalMethodName = ((IMethod)element).getElementName();
            newMethodName = OperatorsRegistry.getNewMethodName((IMethod)element, arguments);
            if (newMethodName.equals(originalMethodName)) {
                return Collections.EMPTY_LIST;
            }
        }
        if (newPackageName == null && newClassName == null && newMethodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList triggerTypes = model.getTriggerType();
        int i = 0;
        while (i < triggerTypes.size()) {
            TriggerTypeType type = (TriggerTypeType)triggerTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList triggers = type.getTriggers();
                int j = 0;
                while (j < triggers.size()) {
                    TriggerType trigger = (TriggerType)triggers.get(j);
                    if (element instanceof IPackageFragment) {
                        this.processAccessPointsPackage(result, trigger, originalPackageName, newPackageName);
                    } else if (element instanceof IType) {
                        this.processAccessPoints(result, trigger, originalClassName, newClassName);
                    } else if (element instanceof IMethod) {
                        this.processParameterMappings(result, trigger, originalMethodName, newMethodName);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        String packageName = null;
        if (element instanceof IPackageFragment) {
            packageName = ((IPackageFragment)element).getElementName();
        }
        String className = null;
        if (element instanceof IType) {
            className = ((IType)element).getFullyQualifiedName();
        }
        String methodName = null;
        if (element instanceof IMethod) {
            methodName = ((IMethod)element).getElementName();
        }
        if (packageName == null && className == null && methodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList triggerTypes = model.getTriggerType();
        int i = 0;
        while (i < triggerTypes.size()) {
            TriggerTypeType type = (TriggerTypeType)triggerTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList triggers = type.getTriggers();
                int j = 0;
                while (j < triggers.size()) {
                    TriggerType trigger = (TriggerType)triggers.get(j);
                    if (!(element instanceof IPackageFragment)) {
                        if (element instanceof IType) {
                            this.queryAccessPoints(result, file, trigger, className);
                        } else if (element instanceof IMethod) {
                            this.queryParameterMappings(result, file, trigger, methodName);
                        }
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    private void queryParameterMappings(List result, IFile file, TriggerType trigger, String methodName) {
        EList parameterMappings = trigger.getParameterMapping();
        int i = 0;
        while (i < parameterMappings.size()) {
            ParameterMappingType param = (ParameterMappingType)parameterMappings.get(i);
            EObjectMatch.addMethodMatch(result, file, (EObject)param, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getParameterMappingType_ParameterPath(), methodName);
            ++i;
        }
    }

    private void processParameterMappings(List result, TriggerType trigger, String originalMethodName, String newMethodName) {
        EList parameterMappings = trigger.getParameterMapping();
        int i = 0;
        while (i < parameterMappings.size()) {
            ParameterMappingType param = (ParameterMappingType)parameterMappings.get(i);
            EObjectStringValueSubstituteChange.addMethodSubstitution(result, "access path", (EObject)param, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getParameterMappingType_ParameterPath(), originalMethodName, newMethodName);
            ++i;
        }
    }

    private void queryAccessPoints(List result, IFile file, TriggerType trigger, String className) {
        EList accessPoints = trigger.getAccessPoint();
        int i = 0;
        while (i < accessPoints.size()) {
            AccessPointType ap = (AccessPointType)accessPoints.get(i);
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)ap, (String)"carnot:engine:className");
            if (attribute != null && className.equals(attribute.getValue())) {
                result.add(new EObjectMatch(file, attribute, 0, className.length()));
            }
            ++i;
        }
    }

    private void processAccessPoints(List result, TriggerType trigger, String originalClassName, String newClassName) {
        EList accessPoints = trigger.getAccessPoint();
        int i = 0;
        while (i < accessPoints.size()) {
            String className;
            AccessPointType ap = (AccessPointType)accessPoints.get(i);
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)ap, (String)"carnot:engine:className");
            if (attribute != null && originalClassName.equals(className = attribute.getValue())) {
                result.add(new AttributeValueChange(attribute, newClassName));
            }
            ++i;
        }
    }

    private void processAccessPointsPackage(List result, TriggerType trigger, String originalClassName, String newClassName) {
        EList accessPoints = trigger.getAccessPoint();
        int i = 0;
        while (i < accessPoints.size()) {
            String className;
            AccessPointType ap = (AccessPointType)accessPoints.get(i);
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)ap, (String)"carnot:engine:className");
            if (attribute != null && RefactoringUtils.containsPackage(className = attribute.getValue(), originalClassName)) {
                result.add(new AttributeValueChange(attribute, RefactoringUtils.getNewClassName(className, originalClassName, newClassName)));
            }
            ++i;
        }
    }
}

