/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.templates.views.WorkflowModelEditorAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PartListener
implements IPartListener {
    private WorkflowModelEditorAction action;
    private Set registeredEditors = new HashSet();

    public PartListener(WorkflowModelEditorAction action) {
        this.action = action;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.removeAction(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.registerAction(part);
    }

    public void register(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
        IEditorReference[] refs = page.getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            IEditorPart editor = refs[i].getEditor(false);
            this.registerAction((IWorkbenchPart)editor);
            ++i;
        }
    }

    public void unregister(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
        IEditorReference[] refs = page.getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            IEditorPart editor = refs[i].getEditor(false);
            this.removeAction((IWorkbenchPart)editor);
            ++i;
        }
    }

    private void registerAction(IWorkbenchPart part) {
        if (part instanceof WorkflowModelEditor && !this.registeredEditors.contains(part)) {
            this.registeredEditors.add(part);
            this.action.register((WorkflowModelEditor)part);
        }
    }

    private void removeAction(IWorkbenchPart part) {
        if (part instanceof WorkflowModelEditor && this.registeredEditors.contains(part)) {
            this.registeredEditors.remove(part);
            this.action.unregister((WorkflowModelEditor)part);
        }
    }
}

