/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.stardust.modeling.templates.views.PartListener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class WorkbenchPageListener
implements IPageListener {
    private PartListener partListener;
    private Set registeredPages = new HashSet();

    public WorkbenchPageListener(PartListener partListener) {
        this.partListener = partListener;
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        this.removeListeners(page);
    }

    public void pageOpened(IWorkbenchPage page) {
        this.registerListeners(page);
    }

    public void register(IWorkbenchWindow window) {
        window.addPageListener((IPageListener)this);
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            this.registerListeners(pages[i]);
            ++i;
        }
    }

    public void unregister(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            this.removeListeners(pages[i]);
            ++i;
        }
    }

    private void registerListeners(IWorkbenchPage page) {
        if (!this.registeredPages.contains(page)) {
            this.registeredPages.add(page);
            this.partListener.register(page);
        }
    }

    private void removeListeners(IWorkbenchPage page) {
        if (this.registeredPages.contains(page)) {
            this.registeredPages.remove(page);
            this.partListener.unregister(page);
        }
    }
}

