/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.stardust.engine.core.javascript.StructuredDataMapAccessor;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.modeling.transformation.debug.model.AbstractVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsStackFrame;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataMapValue;

public class StructuredDataMapVariable
extends AbstractVariable {
    private final StructuredDataMapAccessor accessor;
    private final TypedXPath typedXPath;
    private final String name;
    private final JsStackFrame stackFrame;

    public StructuredDataMapVariable(JsStackFrame stackFrame, AbstractVariable parent, String name, StructuredDataMapAccessor accessor) {
        this(stackFrame, parent, name, accessor, accessor.getXPath());
    }

    public StructuredDataMapVariable(JsStackFrame stackFrame, AbstractVariable parent, String name, StructuredDataMapAccessor accessor, TypedXPath typedXPath) {
        super(stackFrame, parent);
        this.accessor = accessor;
        this.typedXPath = typedXPath;
        this.name = name;
        this.stackFrame = stackFrame;
    }

    public JsStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public StructuredDataMapAccessor getAccessor() {
        return this.accessor;
    }

    public TypedXPath getTypedXPath() {
        return this.typedXPath;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getTypedXPath().getXsdTypeName();
    }

    public IValue getValue() throws DebugException {
        return new StructuredDataMapValue(this);
    }

    @Override
    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    @Override
    public boolean supportsValueModification() {
        return false;
    }
}

