/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling;

import java.util.Calendar;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IAccessPointOwner;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.impl.AccessPointTypeImpl;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.integration.dms.data.DmsTypeUtils;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MTAClassLoader;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class MessageTransformationUtils {
    private IJavaProject javaProject;
    private IModelElement modelElement;
    private MTAClassLoader mtaClassLoader;

    public MessageTransformationUtils(IProject project, IModelElement modelElement, ModelType modelType) {
        this.javaProject = JavaCore.create((IProject)project);
        this.modelElement = modelElement;
        this.mtaClassLoader = new MTAClassLoader(this.javaProject);
    }

    public MessageTransformationUtils() {
    }

    public boolean classExists(String className) {
        return this.mtaClassLoader.findClass(className) != null;
    }

    public StructAccessPointType createStructAccessPoint(String id, String name, DirectionType direction, DataTypeType type, TypedXPath typedXPath, IXPathMap xPathMap) {
        StructAccessPointType result = new StructAccessPointType(typedXPath, xPathMap);
        result.setId(id);
        result.setName(name);
        result.setType(type);
        result.setDirection(direction);
        return result;
    }

    public AccessPointType createPrimitiveAccessPoint(IIdentifiableModelElement declaringType, String messageName, DirectionType direction) {
        Class<?> clazz = null;
        String type = AttributeUtil.getAttributeValue((IExtensibleElement)declaringType, (String)"carnot:engine:type");
        if (declaringType instanceof DataTypeType) {
            type = messageName;
        }
        clazz = this.getClassForType(type);
        AccessPointType accessPoint = DmsTypeUtils.createPrimitiveAccessPointType((String)messageName, clazz, (DirectionType)direction, (IModelElement)this.modelElement);
        AttributeUtil.setAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:type", (String)"ag.carnot.workflow.spi.providers.data.java.Type", (String)type);
        return accessPoint;
    }

    public AccessPointType createSerializableAccessPoint(TypeInfo declaringType, String messageName, DirectionType direction) {
        try {
            AccessPointType apt = DmsTypeUtils.createSerializableAccessPointType((String)messageName, (String)declaringType.getFullName(), (DirectionType)direction, (IModelElement)this.modelElement);
            return apt;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public AccessPointType createStructAccessPoint(EObject declaringType, String messageName, DirectionType direction, boolean includePathInName) {
        TypeDeclarationType typeDeclaration = declaringType instanceof TypeDeclarationType ? (TypeDeclarationType)declaringType : StructuredTypeUtils.getStructuredAccessPointTypeDeclaration((IExtensibleElement)((StructAccessPointType)declaringType));
        IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)typeDeclaration);
        DataTypeType structDataType = ModelUtils.getDataType((IModelElement)this.modelElement, (String)"struct");
        StructAccessPointType accessPoint = this.createStructAccessPoint(messageName, messageName, direction, structDataType, xPathMap.getRootXPath(), xPathMap);
        ((AccessPointTypeImpl)accessPoint).setFakeContainer((IAccessPointOwner)this.modelElement);
        StructuredTypeUtils.setStructuredAccessPointAttributes((IExtensibleElement)accessPoint, (TypeDeclarationType)typeDeclaration);
        ((AccessPointTypeImpl)accessPoint).setFakeContainer(null);
        String path = AttributeUtil.getAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType").getValue();
        accessPoint.setName(includePathInName ? String.valueOf(messageName) + " (" + this.parseName(path) + ")" : messageName);
        return accessPoint;
    }

    private String parseName(String path) {
        if (path.startsWith("typeDeclaration:")) {
            path = path.replaceAll("typeDeclaration:", "");
            path = path.replace("{", "");
            path = path.replace("}", " / ");
        }
        return path;
    }

    public Class<?> getClassForType(String type) {
        if (type.equalsIgnoreCase("long")) {
            return Long.class;
        }
        if (type.equalsIgnoreCase("long")) {
            return Short.class;
        }
        if (type.equalsIgnoreCase("float")) {
            return Float.class;
        }
        if (type.equalsIgnoreCase("double")) {
            return Double.class;
        }
        if (type.equalsIgnoreCase("byte")) {
            return Byte.class;
        }
        if (type.equalsIgnoreCase("Calendar")) {
            return Calendar.class;
        }
        if (type.equalsIgnoreCase("Timestamp")) {
            return Calendar.class;
        }
        if (type.equalsIgnoreCase("int")) {
            return Integer.class;
        }
        if (type.equalsIgnoreCase("java.lang.Integer")) {
            return Integer.class;
        }
        if (type.equals("String")) {
            return String.class;
        }
        return String.class;
    }

    public boolean isPrimitive(DataType data) {
        return data.getType() != null && data.getType().getId().equalsIgnoreCase("primitive");
    }

    public boolean isSerializable(DataType data) {
        return data.getType() != null && data.getType().getId().equalsIgnoreCase("serializable");
    }

    public AccessPointType extractStructAccessPoints(DataTypeType structuredDataType, AccessPointType accessPoint) {
        TypeDeclarationType typeDeclaration = StructuredTypeUtils.getStructuredAccessPointTypeDeclaration((IExtensibleElement)accessPoint);
        if (typeDeclaration != null) {
            IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)typeDeclaration);
            StructAccessPointType structAP = this.createStructAccessPoint(accessPoint.getId(), accessPoint.getName(), accessPoint.getDirection(), structuredDataType, xPathMap.getRootXPath(), xPathMap);
            structAP.setFakeContainer((IAccessPointOwner)this.modelElement);
            StructuredTypeUtils.setStructuredAccessPointAttributes((IExtensibleElement)structAP, (TypeDeclarationType)typeDeclaration);
            structAP.setFakeContainer(null);
            return structAP;
        }
        return null;
    }

    public AccessPointType extractPrimitiveAccessPoints(DataTypeType structuredDataType, AccessPointType accessPoint) {
        AccessPointType primAccessPoint = DmsTypeUtils.createPrimitiveAccessPointType((String)accessPoint.getId(), String.class, (DirectionType)accessPoint.getDirection(), (IModelElement)accessPoint);
        AttributeUtil.setAttribute((IExtensibleElement)primAccessPoint, (String)"carnot:engine:type", (String)"ag.carnot.workflow.spi.providers.data.java.Type", (String)AttributeUtil.getAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:type").getValue());
        return primAccessPoint;
    }

    public AccessPointType extractSerializableAccessPoints(DataTypeType structuredDataType, AccessPointType accessPoint) {
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:className");
        AccessPointType primAccessPoint = DmsTypeUtils.createSerializableAccessPointType((String)accessPoint.getId(), (String)className, (DirectionType)accessPoint.getDirection(), (IModelElement)accessPoint);
        return primAccessPoint;
    }

    public AccessPointType createSerializableAccessPoints(IModelElement modelElement, String className, String id) {
        AccessPointType serializableAccessPoint = DmsTypeUtils.createSerializableAccessPointType((String)id, (String)className, (DirectionType)DirectionType.OUT_LITERAL, (IModelElement)modelElement);
        return serializableAccessPoint;
    }

    public boolean isPrimitive(AccessPointType apt) {
        return apt != null && !(apt instanceof StructAccessPointType) && apt.getType() != null && apt.getType().getId() != null && apt.getType().getId().startsWith("prim");
    }
}

