/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.debug.CwmFileSelectionDialog;
import org.eclipse.stardust.modeling.transformation.messaging.format.FormatManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.TypesLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;

public class ProcessingConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Button testSerializationCheckbox;
    private Text sourceFilePathText;
    private Text targetFilePathText;
    private Text projectText;
    private ComboViewer sourceFormatComboViewer;
    private ComboViewer targetFormatComboViewer;
    private Button screenOutputCheckbox;
    private Text modelText;
    private String modelUri = "";
    private ComboViewer legoComboViewer;

    public void createControl(Composite parent) {
        Label label;
        Label label2;
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.setControl((Control)composite);
        FormBuilder.createLabel((Composite)composite, (String)Modeling_Messages.MSG_READING_DATA_FROM_SOURCEMESSAGE);
        Group group2 = new Group(composite, 0);
        FormLayout layout2 = new FormLayout();
        layout2.marginHeight = 10;
        layout2.marginWidth = 10;
        group2.setLayout((Layout)layout2);
        group2.setText(Modeling_Messages.TXT_STR_DATA_SEL);
        Label layoutDirective2 = label2 = new Label((Composite)group2, 0);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(0, 0);
        formData2.top = new FormAttachment(0, 0);
        formData2.width = 200;
        label2.setLayoutData((Object)formData2);
        label2.setText(Modeling_Messages.TXT_PROJECT);
        this.projectText = new Text((Composite)group2, 2060);
        formData2 = new FormData();
        formData2.left = new FormAttachment((Control)layoutDirective2, 5, 131072);
        formData2.top = new FormAttachment((Control)label2, 0, 128);
        formData2.width = 300;
        this.projectText.setLayoutData((Object)formData2);
        Button browseProjectsButton = new Button((Composite)group2, 0);
        formData2 = new FormData();
        formData2.left = new FormAttachment((Control)this.projectText, 5, 131072);
        formData2.top = new FormAttachment((Control)label2, 0, 128);
        browseProjectsButton.setLayoutData((Object)formData2);
        browseProjectsButton.setText(Modeling_Messages.TXT_BW_DREI_PUNKT);
        browseProjectsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingConfigurationTab.this.browseProjects();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label2 = new Label((Composite)group2, 0);
        formData2 = new FormData();
        formData2.left = new FormAttachment(0, 0);
        formData2.top = new FormAttachment((Control)this.projectText, 5, 1024);
        label2.setLayoutData((Object)formData2);
        label2.setText(Modeling_Messages.TXT_PRC);
        this.modelText = new Text((Composite)group2, 2060);
        formData2 = new FormData();
        formData2.left = new FormAttachment((Control)layoutDirective2, 5, 131072);
        formData2.top = new FormAttachment((Control)label2, 0, 128);
        formData2.width = 300;
        this.modelText.setLayoutData((Object)formData2);
        Button browseModelsButton = new Button((Composite)group2, 0);
        formData2 = new FormData();
        formData2.left = new FormAttachment((Control)this.modelText, 5, 131072);
        formData2.top = new FormAttachment((Control)label2, 0, 128);
        browseModelsButton.setLayoutData((Object)formData2);
        browseModelsButton.setText(Modeling_Messages.TXT_BW_DREI_PUNKT);
        browseModelsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingConfigurationTab.this.browseModelFiles();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label2 = new Label((Composite)group2, 0);
        formData2 = new FormData();
        formData2.left = new FormAttachment(0, 0);
        formData2.top = new FormAttachment((Control)this.modelText, 5, 1024);
        label2.setLayoutData((Object)formData2);
        label2.setText(Modeling_Messages.TXT_STR_DATA);
        TypesLabelProvider labelProvider = new TypesLabelProvider();
        Combo legoCombo = new Combo((Composite)group2, 128);
        this.legoComboViewer = new ComboViewer(legoCombo);
        this.legoComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.legoComboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.legoComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TypeDeclarationType legoType = (TypeDeclarationType)selection.getFirstElement();
                legoType.getName();
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        formData2 = new FormData();
        formData2.left = new FormAttachment((Control)layoutDirective2, 5, 131072);
        formData2.top = new FormAttachment((Control)label2, 0, 128);
        formData2.width = 300;
        legoCombo.setLayoutData((Object)formData2);
        final Group group = new Group(composite, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        group.setText(Modeling_Messages.TXT_PR);
        Label layoutDirective = label = new Label((Composite)group, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.width = 200;
        label.setLayoutData((Object)formData);
        label.setText(Modeling_Messages.TXT_SR_MSG_FILE);
        this.sourceFilePathText = new Text((Composite)group, 2052);
        formData = new FormData();
        formData.left = new FormAttachment((Control)layoutDirective, 5, 131072);
        formData.top = new FormAttachment((Control)label, 0, 128);
        formData.width = 300;
        this.sourceFilePathText.setLayoutData((Object)formData);
        this.sourceFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = new Button((Composite)group, 0);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.sourceFilePathText, 5, 131072);
        formData.top = new FormAttachment((Control)label, 0, 128);
        button.setLayoutData((Object)formData);
        button.setText(Modeling_Messages.TXT_BW_DREI_PUNKT);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(group.getShell(), 8192);
                fd.setText(Modeling_Messages.TXT_BW);
                fd.setFilterPath("C:/");
                String fileName = fd.open();
                if (fileName != null) {
                    ProcessingConfigurationTab.this.sourceFilePathText.setText(fileName);
                } else {
                    ProcessingConfigurationTab.this.sourceFilePathText.setText("");
                }
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)group, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.sourceFilePathText, 5, 1024);
        label.setLayoutData((Object)formData);
        label.setText(Modeling_Messages.TXT_SR_MSG_FORMAT);
        this.sourceFormatComboViewer = new ComboViewer((Composite)group);
        formData = new FormData();
        formData.left = new FormAttachment((Control)layoutDirective, 5, 131072);
        formData.top = new FormAttachment((Control)label, 0, 128);
        this.sourceFormatComboViewer.getControl().setLayoutData((Object)formData);
        this.sourceFormatComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sourceFormatComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    return element.toString();
                }
                return null;
            }
        });
        this.sourceFormatComboViewer.setInput(FormatManager.getMessageFormats());
        this.sourceFormatComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testSerializationCheckbox = FormBuilder.createCheckBox((Composite)composite, (String)Modeling_Messages.BOX_TEST_SER);
        this.testSerializationCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
                if (ProcessingConfigurationTab.this.testSerializationCheckbox.getSelection()) {
                    ProcessingConfigurationTab.this.enableTargetSettings();
                } else {
                    ProcessingConfigurationTab.this.disableTargetSettings();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Group targetGroup = new Group(composite, 0);
        layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        targetGroup.setLayout((Layout)layout);
        targetGroup.setText(Modeling_Messages.TXT_SER);
        this.screenOutputCheckbox = new Button((Composite)targetGroup, 32);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        this.screenOutputCheckbox.setText(Modeling_Messages.TXT_SCREEN_OP);
        layoutDirective = label = new Label((Composite)targetGroup, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.screenOutputCheckbox, 5, 1024);
        formData.width = 200;
        label.setLayoutData((Object)formData);
        label.setText(Modeling_Messages.TXT_TARGET_MSG_FILE);
        this.targetFilePathText = new Text((Composite)targetGroup, 2052);
        this.targetFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment((Control)layoutDirective, 5, 131072);
        formData.top = new FormAttachment((Control)label, 0, 128);
        formData.width = 300;
        this.targetFilePathText.setLayoutData((Object)formData);
        button = new Button((Composite)targetGroup, 0);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.targetFilePathText, 5, 131072);
        formData.top = new FormAttachment((Control)label, 0, 128);
        button.setLayoutData((Object)formData);
        button.setText(Modeling_Messages.TXT_BW_DREI_PUNKT);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(targetGroup.getShell(), 8192);
                fd.setText(Modeling_Messages.TXT_BW);
                fd.setFilterPath("C:/");
                String sourceFilePath = fd.open();
                if (sourceFilePath != null) {
                    ProcessingConfigurationTab.this.targetFilePathText.setText(sourceFilePath);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)targetGroup, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.targetFilePathText, 5, 1024);
        label.setLayoutData((Object)formData);
        label.setText(Modeling_Messages.TXT_TARGET_MSG_FORMAT);
        this.targetFormatComboViewer = new ComboViewer((Composite)targetGroup);
        formData = new FormData();
        formData.left = new FormAttachment((Control)layoutDirective, 5, 131072);
        formData.top = new FormAttachment((Control)label, 0, 128);
        formData.width = 150;
        this.targetFormatComboViewer.getControl().setLayoutData((Object)formData);
        this.targetFormatComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.targetFormatComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    return element.toString();
                }
                return null;
            }
        });
        this.targetFormatComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.targetFormatComboViewer.setInput(FormatManager.getMessageFormats());
        this.screenOutputCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
                if (ProcessingConfigurationTab.this.screenOutputCheckbox.getSelection()) {
                    ProcessingConfigurationTab.this.targetFilePathText.setEnabled(false);
                } else {
                    ProcessingConfigurationTab.this.targetFilePathText.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.testSerializationCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingConfigurationTab.this.updateLaunchConfigurationDialog();
                if (ProcessingConfigurationTab.this.testSerializationCheckbox.getSelection()) {
                    ProcessingConfigurationTab.this.targetFilePathText.setEnabled(true);
                    ProcessingConfigurationTab.this.screenOutputCheckbox.setEnabled(true);
                    ProcessingConfigurationTab.this.targetFormatComboViewer.getCombo().setEnabled(true);
                    if (ProcessingConfigurationTab.this.screenOutputCheckbox.getSelection()) {
                        ProcessingConfigurationTab.this.targetFilePathText.setEnabled(false);
                    }
                } else {
                    ProcessingConfigurationTab.this.targetFormatComboViewer.getCombo().setEnabled(false);
                    ProcessingConfigurationTab.this.targetFilePathText.setEnabled(false);
                    ProcessingConfigurationTab.this.screenOutputCheckbox.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.testSerializationCheckbox.setSelection(false);
        this.disableTargetSettings();
    }

    private void enableTargetSettings() {
        this.screenOutputCheckbox.setEnabled(true);
        this.targetFilePathText.setEnabled(true);
        this.targetFormatComboViewer.getControl().setEnabled(true);
    }

    private void disableTargetSettings() {
        this.screenOutputCheckbox.setEnabled(false);
        this.screenOutputCheckbox.setSelection(false);
        this.targetFilePathText.setEnabled(false);
        this.targetFormatComboViewer.getControl().setEnabled(false);
    }

    public String getName() {
        return Modeling_Messages.TXT_MSG_PRC_TEST_CFG;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String targetMessageFormat;
            this.projectText.setText(configuration.getAttribute("ippProject", ""));
            this.modelText.setText(configuration.getAttribute("modelName", ""));
            this.modelUri = configuration.getAttribute("modelUri", "");
            if (this.modelUri != "") {
                try {
                    ModelType model = this.loadModel(this.modelUri);
                    EList dataTypes = model.getTypeDeclarations().getTypeDeclaration();
                    this.legoComboViewer.setInput((Object)dataTypes);
                    String declaredTypeId = configuration.getAttribute("legoData", "");
                    this.legoComboViewer.setSelection((ISelection)new StructuredSelection((Object)ModelUtils.getTypeDeclaration((IExtensibleElement)model, (String)declaredTypeId)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.sourceFilePathText.setText(configuration.getAttribute("sourceFilePath", ""));
            String sourceMessageFormat = configuration.getAttribute("sourceFormat", "");
            if (sourceMessageFormat != null) {
                this.sourceFormatComboViewer.setSelection((ISelection)new StructuredSelection((Object)sourceMessageFormat));
            }
            configuration.getAttribute("sourceFormatModel", "");
            this.targetFilePathText.setText(configuration.getAttribute("targetFilePath", ""));
            this.testSerializationCheckbox.setSelection(configuration.getAttribute("testSerialization", false));
            if (configuration.getAttribute("testSerialization", true)) {
                this.screenOutputCheckbox.setEnabled(true);
                this.targetFormatComboViewer.getCombo().setEnabled(true);
                if (configuration.getAttribute("screenOnly", false)) {
                    this.screenOutputCheckbox.setSelection(true);
                    this.targetFilePathText.setEnabled(false);
                } else {
                    this.screenOutputCheckbox.setSelection(false);
                    this.targetFilePathText.setEnabled(true);
                    this.targetFormatComboViewer.getCombo().setEnabled(true);
                }
                this.targetFilePathText.setText(configuration.getAttribute("targetFilePath", ""));
            }
            if ((targetMessageFormat = configuration.getAttribute("targetFormat", "")) != null) {
                this.targetFormatComboViewer.setSelection((ISelection)new StructuredSelection((Object)targetMessageFormat));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("ippProject", this.projectText.getText());
        configuration.setAttribute("modelName", this.modelText.getText());
        configuration.setAttribute("modelUri", this.modelUri);
        if (!this.legoComboViewer.getSelection().isEmpty()) {
            TypeDeclarationType selectedTypeDeclaration = (TypeDeclarationType)((IStructuredSelection)this.legoComboViewer.getSelection()).getFirstElement();
            configuration.setAttribute("legoData", selectedTypeDeclaration.getId());
        }
        configuration.setAttribute("sourceFilePath", this.sourceFilePathText.getText());
        configuration.setAttribute("targetFilePath", this.targetFilePathText.getText());
        if (this.sourceFormatComboViewer.getSelection() != null) {
            configuration.setAttribute("sourceFormat", (String)((IStructuredSelection)this.sourceFormatComboViewer.getSelection()).getFirstElement());
        }
        if (this.testSerializationCheckbox.getSelection()) {
            if (this.targetFormatComboViewer.getSelection() != null) {
                configuration.setAttribute("targetFormat", (String)((IStructuredSelection)this.targetFormatComboViewer.getSelection()).getFirstElement());
            }
            if (this.screenOutputCheckbox.getSelection()) {
                configuration.setAttribute("screenOnly", true);
            } else {
                configuration.setAttribute("screenOnly", false);
                configuration.setAttribute("targetFilePath", this.targetFilePathText.getText());
            }
        }
        configuration.setAttribute("testSerialization", this.testSerializationCheckbox.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("testSerialization", false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (StringUtils.isEmpty((String)this.projectText.getText())) {
            this.setErrorMessage(Modeling_Messages.MSG_NO_PROJECT_SEL);
            return false;
        }
        if (StringUtils.isEmpty((String)this.modelText.getText())) {
            this.setErrorMessage(Modeling_Messages.MSG_NO_PROCESS_MD_SEL);
            return false;
        }
        if (this.legoComboViewer.getSelection().isEmpty()) {
            this.setErrorMessage(Modeling_Messages.MSG_NO_STRUCTURED_TYPE_SEL);
            return false;
        }
        if (StringUtils.isEmpty((String)this.sourceFilePathText.getText())) {
            this.setErrorMessage(Modeling_Messages.MSG_NO_SR_FILE_SEL);
            return false;
        }
        if (this.sourceFormatComboViewer.getSelection().isEmpty()) {
            this.setErrorMessage(Modeling_Messages.MSG_NO_MSG_FORMAT_SEL);
            return false;
        }
        if (this.testSerializationCheckbox.getSelection()) {
            if (this.targetFormatComboViewer.getSelection().isEmpty()) {
                return false;
            }
            if (!this.screenOutputCheckbox.getSelection() && StringUtils.isEmpty((String)this.targetFilePathText.getText())) {
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private void browseProjects() {
        IJavaProject javaProject;
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaScriptElementLabelProvider labelProvider = new JavaScriptElementLabelProvider(18);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Modeling_Messages.DIA_MSG_TRANS_RUN_CFG);
        dialog.setElements(projects);
        String projectName = this.projectText.getText();
        if (!StringUtils.isEmpty((String)projectName) && (javaProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))) != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            javaProject = (IJavaProject)dialog.getFirstResult();
            if (javaProject != null) {
                this.updateLaunchConfigurationDialog();
                this.projectText.setText(javaProject.getElementName());
                this.modelText.setText("");
                this.legoComboViewer.setInput(null);
            } else {
                this.projectText.setText("");
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    private void browseModelFiles() {
        String projectName = this.projectText.getText();
        if (StringUtils.isEmpty((String)projectName)) {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
            messageBox.setText(Modeling_Messages.TXT_WR_LEER);
            messageBox.setMessage(Modeling_Messages.MSG_FIRST_NEED_SELECTED_PROJECT);
            messageBox.open();
        } else {
            CwmFileSelectionDialog dialog = new CwmFileSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), 1);
            if (dialog.open() == 0) {
                Object[] files = dialog.getResult();
                IFile modelFile = (IFile)files[0];
                this.modelUri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true).toString();
                String fullPath = modelFile.getFullPath().toString();
                this.modelText.setText(fullPath.substring(projectName.length() + 2));
                this.updateLaunchConfigurationDialog();
                this.updateStructruredData();
            }
        }
    }

    private void updateStructruredData() {
        ModelType sdModel = null;
        try {
            sdModel = this.loadModel(this.modelUri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EList dataTypes = sdModel.getTypeDeclarations().getTypeDeclaration();
        this.legoComboViewer.setInput((Object)dataTypes);
        this.updateLaunchConfigurationDialog();
    }

    public ModelType loadModel(String modelUri) throws Exception {
        WorkflowModelManager modelManager = new WorkflowModelManager();
        modelManager.load(URI.createURI((String)modelUri));
        ModelType model = modelManager.getModel();
        return model;
    }
}

