/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer;

import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.IMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.StructDataMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MappingConfiguration;

public class PrimitiveMappingRenderer
implements IMappingRenderer {
    private MessageTransformationController controller;
    private AccessPointType messageType;

    public PrimitiveMappingRenderer(MessageTransformationController controller, AccessPointType messageType) {
        this.controller = controller;
        this.messageType = messageType;
    }

    @Override
    public AccessPointType getType() {
        return this.messageType;
    }

    @Override
    public String renderAssignmentCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, String result, MappingConfiguration config) {
        return null;
    }

    @Override
    public String renderGetterCode(boolean ignoreArrays, boolean variablesAsIndices, MappingConfiguration config) {
        return this.messageType.getName();
    }

    @Override
    public String renderListMappingCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, MappingConfiguration config) {
        String targetCondition;
        String result = "";
        String sourceArray = sourceMapper.renderGetterCode(false, true, config);
        String targetArray = targetMapper.renderGetterCode(false, true, config);
        if (targetMapper instanceof StructDataMappingRenderer && this.controller.isList(targetMapper.getType())) {
            int idx1 = targetArray.lastIndexOf("[");
            int idx2 = targetArray.lastIndexOf("]");
            targetArray = targetArray.substring(0, targetArray.length() - (idx2 - idx1) - 1);
            targetArray = String.valueOf(targetArray) + "[n0]";
        }
        if ((targetCondition = targetMapper.renderGetterCode(false, true, config)).endsWith("]") && targetMapper instanceof StructDataMappingRenderer) {
            int idx1 = targetCondition.lastIndexOf("[");
            int idx2 = targetCondition.lastIndexOf("]");
            targetCondition = targetCondition.substring(0, targetCondition.length() - (idx2 - idx1) - 1);
        }
        int index = 0;
        if (depth > 9) {
            index = 1;
        }
        sourceArray.substring(0, sourceArray.length() - 4 - index);
        targetArray.substring(0, sourceArray.length() - 4 - index);
        String varDeclaration = "n" + depth;
        String o = this.controller.getUsedVar().get("n" + depth);
        if (o == null) {
            varDeclaration = "var n" + depth;
            this.controller.getUsedVar().put("n" + depth, "defined");
        }
        result = String.valueOf(result) + inset + "for (" + varDeclaration + " = 0; n" + depth + " < " + targetCondition + ".length; ++n" + depth + "){\n";
        result = this.controller.isComplexType(sourceMapper.getType()) ? this.renderAssignmentCode(sourceMapper, targetMapper, inset, depth, result, config) : String.valueOf(result) + inset + "   " + targetArray + " = " + sourceArray + ";\n";
        result = String.valueOf(result) + inset + "}\n";
        result = result.replace("= null", "= " + AttributeUtil.getAttributeValue((IExtensibleElement)sourceMapper.getType(), (String)"RootElement"));
        result = result.replace("null", AttributeUtil.getAttributeValue((IExtensibleElement)targetMapper.getType(), (String)"RootElement"));
        return result;
    }

    @Override
    public String renderSetterCode(String getterCode, boolean ignoreArrays, boolean variablesAsIndices, MappingConfiguration config) {
        return getterCode;
    }

    @Override
    public String getTypeString() {
        String typeString;
        AttributeType attType = AttributeUtil.getAttribute((IExtensibleElement)this.messageType, (String)"carnot:engine:type");
        if (attType != null && (typeString = attType.getValue()) != null) {
            if (typeString.equals("java.lang.String")) {
                return "String";
            }
            if (typeString.equals("java.lang.Byte")) {
                return "Number";
            }
            if (typeString.equals("java.lang.Integer")) {
                return "Number";
            }
            if (typeString.equals("java.lang.Long")) {
                return "Number";
            }
            if (typeString.equals("java.lang.Float")) {
                return "Number";
            }
            if (typeString.equals("java.lang.Boolean")) {
                return "Boolean";
            }
            if (typeString.equals("java.lang.Double")) {
                return "Number";
            }
            if (typeString.equalsIgnoreCase("double")) {
                return "Number";
            }
            if (typeString.equalsIgnoreCase("int")) {
                return "Number";
            }
            if (typeString.equalsIgnoreCase("float")) {
                return "Number";
            }
            if (typeString.equalsIgnoreCase("string")) {
                return "String";
            }
            if (typeString.equalsIgnoreCase("short")) {
                return "Number";
            }
            if (typeString.equalsIgnoreCase("long")) {
                return "Number";
            }
            if (typeString.equalsIgnoreCase("byte")) {
                return "Number";
            }
            if (typeString.equalsIgnoreCase("boolean")) {
                return "Boolean";
            }
            if (typeString.equalsIgnoreCase("calendar")) {
                return "Date";
            }
            if (typeString.equalsIgnoreCase("timestamp")) {
                return "Date";
            }
            return "String";
        }
        return " ";
    }

    @Override
    public String renderAdditionCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, MappingConfiguration config) {
        String targetIndex;
        String sourcePath = sourceMapper.renderGetterCode(false, false, config);
        if (sourcePath.endsWith(".")) {
            sourcePath = sourcePath.replace(".", "");
        }
        if ((targetIndex = targetMapper.renderGetterCode(false, false, config)).endsWith(".")) {
            targetIndex = targetIndex.replace(".", "");
        }
        String result = targetIndex;
        if (config.isAppend()) {
            int idx1 = targetIndex.lastIndexOf("[");
            int idx2 = targetIndex.lastIndexOf("]");
            int idx = idx2 - idx1 + 1;
            targetIndex = targetIndex.substring(0, targetIndex.length() - idx);
            targetIndex = String.valueOf(targetIndex) + ".length + 1";
            String xPath = this.controller.getXPathFor(targetMapper.getType());
            config.getIndexMap().put(xPath, targetIndex);
            result = targetMapper.renderGetterCode(false, false, config);
        }
        if (result.endsWith(".")) {
            result = targetIndex.replace(".", "");
        }
        return String.valueOf(result) + " = " + sourcePath + ";";
    }
}

