/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationModelingPlugin;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.PrimitivesFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.SerializableFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.StructuredTypesFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.ExternalClassAdditionDialog;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.ExternalClassesLabelProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ExternalClassesConfigurationDialog
extends Dialog
implements ModifyListener {
    private static final int RESET_ID = 22;
    private Text messageNameText;
    private String tagName;
    private ComboViewer messageComboViewer;
    private MessageTransformationController controller;
    private AccessPointType messageType;
    private String messageName;
    private List messageTypes;
    private String preset;
    private List allMessageTypes = new ArrayList();
    private List typeFilters = new ArrayList();
    private List<AccessPointType> externalClasses = new ArrayList<AccessPointType>();
    private Combo messageCombo;
    private Label errorLabel;
    private WorkflowModelEditor wfme;
    private Composite mainComposite;
    private boolean isError = false;
    private Combo dataTypeCombo;
    private ComboViewer dataTypeComboViewer;
    private Label structLabel;
    private TypeSelectionComposite classBrowser;
    private StackLayout stack;
    private Composite structPrimComposite;
    private Composite classBrowseComposite;
    private Group messageComposite;
    protected ViewerFilter selectedFilter;
    private DirectionType directionType;
    private TableViewer tableViewer;
    private boolean showMissing;

    public ExternalClassesConfigurationDialog(Shell parentShell, MessageTransformationController controller, List messageTypes, String preset, DirectionType directionType) {
        super(parentShell);
        this.setShellStyle(67696);
        this.controller = controller;
        this.messageTypes = messageTypes;
        this.directionType = directionType;
        this.preset = preset;
        this.allMessageTypes.addAll(controller.getSourceMessageTypes());
        this.allMessageTypes.addAll(controller.getTargetMessageTypes());
        this.typeFilters.add(new StructuredTypesFilter());
        this.typeFilters.add(new PrimitivesFilter());
        if (!controller.isSimpleMode()) {
            this.typeFilters.add(new SerializableFilter());
        }
        for (AccessPointType apt : controller.getExternalClassTypes()) {
            this.externalClasses.add(apt);
            if (apt.getElementOid() != -99L) continue;
            this.showMissing = true;
        }
    }

    protected Control createDialogArea(Composite parent) {
        IEditorPart currentEditor;
        this.mainComposite = parent;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof WorkflowModelEditor) {
            this.wfme = (WorkflowModelEditor)currentEditor;
        }
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 3;
        Group tableComposite = new Group(comp, 0);
        tableComposite.setText(Modeling_Messages.TXT_EXTERNAL_CL);
        GridLayout tableCompLayout = new GridLayout();
        tableComposite.setLayout((Layout)tableCompLayout);
        GridData tableCompGridData = new GridData();
        tableCompGridData.grabExcessHorizontalSpace = true;
        tableCompGridData.grabExcessVerticalSpace = true;
        tableCompGridData.horizontalAlignment = 4;
        tableCompGridData.verticalAlignment = 4;
        tableCompGridData.horizontalSpan = 3;
        tableComposite.setLayoutData((Object)tableCompGridData);
        Table table = new Table((Composite)tableComposite, 101124);
        table.setHeaderVisible(true);
        GridData tableData = new GridData();
        tableData.grabExcessHorizontalSpace = true;
        tableData.grabExcessVerticalSpace = true;
        tableData.horizontalAlignment = 4;
        tableData.verticalAlignment = 4;
        table.setLayoutData((Object)tableData);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384, 0);
        column.setText(Modeling_Messages.TXT_INSTANCE_NAME);
        column.setWidth(150);
        column = new TableColumn(table, 16384, 1);
        column.setText(Modeling_Messages.TXT_CL_NAME);
        column.setWidth(400);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExternalClassesLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.controller.getExternalClassTypes());
        if (this.showMissing) {
            this.errorLabel = new Label(comp, 0);
            this.errorLabel.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error.gif").createImage());
            this.errorLabel.setVisible(true);
            this.errorLabel = new Label(comp, 0);
            this.errorLabel.setText(Modeling_Messages.TXT_LEAST_ONE_EXTERNAL_CL_IS_MISSING_DEL_CORRE_ENT_OR_ADD_CLASSPATH);
            this.errorLabel.setVisible(true);
        }
        Composite buttonComposite = new Composite((Composite)tableComposite, 0);
        RowLayout buttonCompLayout = new RowLayout();
        buttonComposite.setLayout((Layout)buttonCompLayout);
        RowData buttonCompRowData = new RowData();
        buttonCompRowData.height = 23;
        buttonCompRowData.width = 70;
        Button addButton = new Button(buttonComposite, 0);
        addButton.setLayoutData((Object)buttonCompRowData);
        addButton.setText(Modeling_Messages.TXT_ADD_DREI_PUNKT);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalClassAdditionDialog dialog = new ExternalClassAdditionDialog(Display.getCurrent().getActiveShell(), ExternalClassesConfigurationDialog.this.controller, ExternalClassesConfigurationDialog.this.controller.getExternalClassTypes(), "", DirectionType.IN_LITERAL);
                if (dialog.open() == 0) {
                    AccessPointType ap = ExternalClassesConfigurationDialog.this.controller.createExternalClass(dialog.getMessageType(), dialog.getMessageName(), false);
                    ap.setElementOid(1L);
                    ExternalClassesConfigurationDialog.this.externalClasses.add(ap);
                    ExternalClassesConfigurationDialog.this.tableViewer.setInput((Object)ExternalClassesConfigurationDialog.this.externalClasses);
                }
            }
        });
        Button removeButton = new Button(buttonComposite, 0);
        removeButton.setLayoutData((Object)buttonCompRowData);
        removeButton.setText(Modeling_Messages.TXT_REMOVE);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ExternalClassesConfigurationDialog.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    AccessPointType externalClassAP = (AccessPointType)selection.getFirstElement();
                    ExternalClassesConfigurationDialog.this.externalClasses.remove(externalClassAP);
                    externalClassAP.setElementOid(0L);
                    ExternalClassesConfigurationDialog.this.tableViewer.setInput((Object)ExternalClassesConfigurationDialog.this.externalClasses);
                }
            }
        });
        parent.getShell().setMinimumSize(600, 300);
        parent.getShell().setText(Modeling_Messages.TXT_CFG_EXT_CL);
        return comp;
    }

    private void initCombos() {
        this.messageComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ExternalClassesConfigurationDialog.this.messageType = (AccessPointType)selection.getFirstElement();
                    String text = ExternalClassesConfigurationDialog.this.messageType.getId();
                    int n = 1;
                    while (ExternalClassesConfigurationDialog.this.isAccessPointIdDefined(String.valueOf(text) + n)) {
                        ++n;
                    }
                    text = String.valueOf(text) + n;
                    ExternalClassesConfigurationDialog.this.messageNameText.setText(text);
                    ExternalClassesConfigurationDialog.this.messageNameText.setSelection(0, ExternalClassesConfigurationDialog.this.messageNameText.getText().length());
                }
                ExternalClassesConfigurationDialog.this.buttonEnablement();
            }
        });
        this.dataTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ExternalClassesConfigurationDialog.this.selectedFilter = (ViewerFilter)selection.getFirstElement();
                ExternalClassesConfigurationDialog.this.messageComboViewer.setFilters(new ViewerFilter[]{ExternalClassesConfigurationDialog.this.selectedFilter});
                ((ExternalClassesConfigurationDialog)ExternalClassesConfigurationDialog.this).stack.topControl = ExternalClassesConfigurationDialog.this.selectedFilter instanceof SerializableFilter ? ExternalClassesConfigurationDialog.this.classBrowseComposite : ExternalClassesConfigurationDialog.this.structPrimComposite;
                ExternalClassesConfigurationDialog.this.messageComposite.setText(String.valueOf(Modeling_Messages.TXT_SEL) + ExternalClassesConfigurationDialog.this.selectedFilter.toString());
                ExternalClassesConfigurationDialog.this.messageComposite.layout();
            }
        });
        this.messageComboViewer.setInput(this.controller.getAvailableMessageTypes());
        this.messageComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ExternalClassesConfigurationDialog.this.messageType = (AccessPointType)selection.getFirstElement();
                }
            }
        });
        this.dataTypeComboViewer.setInput((Object)this.typeFilters);
        ArrayList filterSelection = new ArrayList();
        filterSelection.add(this.typeFilters.get(0));
        this.dataTypeComboViewer.setSelection((ISelection)new StructuredSelection(filterSelection));
        ArrayList<AccessPointType> selection = new ArrayList<AccessPointType>();
        selection.add(this.controller.getAvailableMessageTypes().get(0));
        this.messageNameText.setSelection(0, this.messageNameText.getText().length());
    }

    protected void buttonEnablement() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.buttonEnablement();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.controller.getExternalClassTypes().clear();
            for (AccessPointType ap : this.externalClasses) {
                this.controller.createExternalClass(ap, ap.getName(), true);
            }
        }
        super.buttonPressed(buttonId);
    }

    public void modifyText(ModifyEvent arg0) {
        String text = this.messageNameText.getText();
        if (!this.controller.isSimpleMode()) {
            if (this.getMessageTypeByName(text) != null) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_DOES_ALREADY_EXIST, text));
            } else if (!StringUtils.isValidIdentifier((String)text)) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
            } else {
                this.isError = false;
                this.errorLabel.setToolTipText(null);
            }
        } else if (!StringUtils.isValidIdentifier((String)text)) {
            this.isError = true;
            this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
        } else {
            this.isError = false;
            this.errorLabel.setToolTipText(null);
        }
        this.buttonEnablement();
    }

    public AccessPointType getMessageType() {
        return this.messageType;
    }

    public String getMessageName() {
        return this.messageName;
    }

    private boolean isAccessPointIdDefined(String id) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private AccessPointType getMessageTypeByName(String name) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(name)) continue;
            return messageType;
        }
        return null;
    }
}

