/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.core.ui.AccessPathBrowserContentProvider;
import org.eclipse.stardust.modeling.integration.dms.data.DmsTypeUtils;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationUtils;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MTAClassLoader;
import org.eclipse.stardust.modeling.validation.util.FieldInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class MessagingAccessPathBrowserContentProvider
extends AccessPathBrowserContentProvider {
    private DirectionType direction;
    private Map childrenCache = new HashMap();
    private Map parentCache = new HashMap();
    private Object root;
    private MessageTransformationUtils mtaUtils = new MessageTransformationUtils();
    private String rootTypeName;

    public Object[] getChildren(Object parentElement, boolean caching, boolean filterMethods) {
        Object[] children = null;
        if (caching) {
            children = (Object[])this.childrenCache.get(parentElement);
        }
        if (children == null || children.length == 0) {
            children = new Object[]{};
            ITypedElement accessPoint = (ITypedElement)parentElement;
            IMetaType type = accessPoint.getMetaType();
            if (type instanceof DataTypeType) {
                DataTypeType dataType = (DataTypeType)((AccessPointType)this.root).getMetaType();
                if (!dataType.getId().equalsIgnoreCase("primitive")) {
                    IAccessPathEditor editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)dataType);
                    List<Object> aps = editor.getAccessPoints(null, (IExtensibleElement)accessPoint, this.direction);
                    if (AccessPointUtil.isIn((DirectionType)this.direction)) {
                        List inAPs = editor.getAccessPoints(null, (IExtensibleElement)accessPoint, DirectionType.OUT_LITERAL);
                        int i = 0;
                        while (i < inAPs.size()) {
                            IExtensibleElement element = (IExtensibleElement)inAPs.get(i);
                            if (AttributeUtil.getBooleanValue((IExtensibleElement)element, (String)"carnot:engine:browsable")) {
                                aps.contains(element);
                            }
                            ++i;
                        }
                        if (aps != null) {
                            if (dataType.getId().equalsIgnoreCase("serializable") && filterMethods) {
                                try {
                                    String string;
                                    String fullClassName;
                                    AccessPointType parentApt;
                                    ArrayList<AccessPointType> jbAps = new ArrayList<AccessPointType>();
                                    TypeFinder typeFinder = new TypeFinder((EObject)dataType);
                                    String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)parentElement), (String)"carnot:engine:className");
                                    if (className.endsWith("[]") && (parentApt = (AccessPointType)this.parentCache.get(parentElement)) != null && (fullClassName = this.getFullQualifiedName(dataType, className, string = AttributeUtil.getAttributeValue((IExtensibleElement)parentApt, (String)"carnot:engine:className"))) != null) {
                                        fullClassName = fullClassName.replace("[]", "");
                                        AccessPointType newApt = DmsTypeUtils.createSerializableAccessPointType((String)"TestName", (String)fullClassName, (DirectionType)this.direction, (IModelElement)dataType);
                                        aps = Arrays.asList(this.getChildren(newApt, caching, false));
                                        className = fullClassName;
                                    }
                                    if (className.startsWith("java.util.List") && className.indexOf(">") > -1) {
                                        className = className.replace("java.util.List", "");
                                        className = className.replaceAll("<", "");
                                        className = className.replaceAll(">", "");
                                        for (AccessPointType accessPointType : aps) {
                                            if (!accessPointType.getId().equalsIgnoreCase("add(" + className + ")")) continue;
                                            aps = Arrays.asList(this.getChildren(accessPointType, caching, false));
                                        }
                                    }
                                    TypeInfo typeInfo = typeFinder.findType(className);
                                    List list = typeInfo.getFields();
                                    for (FieldInfo fieldInfo : list) {
                                        AccessPointType jbAp = this.getJBStyleAccessPoint(fieldInfo, aps);
                                        if (jbAp == null) continue;
                                        jbAps.add(jbAp);
                                    }
                                    children = jbAps.toArray();
                                }
                                catch (Throwable t) {
                                    System.out.println("Problems with " + AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)parentElement), (String)"carnot:engine:className"));
                                    t.printStackTrace();
                                }
                            } else {
                                children = aps.toArray();
                            }
                        }
                    }
                }
                this.childrenCache.put(parentElement, children);
                int i = 0;
                while (i < children.length) {
                    Object child = children[i];
                    this.parentCache.put(child, parentElement);
                    ++i;
                }
            }
        }
        return children;
    }

    private AccessPointType getJBStyleAccessPoint(FieldInfo fieldInfo, List aps) {
        for (AccessPointType apt : aps) {
            String name = apt.getName();
            if (!apt.getName().startsWith("get")) continue;
            name = name.replace("get", "");
            name = name.replace("()", "");
            if (!fieldInfo.getFieldName().equalsIgnoreCase(name)) continue;
            apt.setId(name);
            apt.setName(name);
            return apt;
        }
        return null;
    }

    public Object getParent(Object element) {
        return this.parentCache.get(element);
    }

    public boolean hasChildren(Object element) {
        if (!(element instanceof AccessPointType)) {
            return false;
        }
        if (this.mtaUtils.isPrimitive((AccessPointType)element)) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = (Object[])this.childrenCache.get(inputElement);
        if (children == null) {
            if (inputElement instanceof ITypedElement && inputElement instanceof IExtensibleElement) {
                ITypedElement accessPoint = (ITypedElement)inputElement;
                children = this.getChildren(accessPoint);
            } else {
                children = new Object[]{};
                this.childrenCache.put(inputElement, children);
            }
        }
        return children;
    }

    public void dispose() {
        this.childrenCache.clear();
        this.parentCache.clear();
        this.childrenCache = null;
        this.parentCache = null;
        this.root = null;
        this.direction = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.childrenCache.clear();
        this.parentCache.clear();
        this.root = newInput;
    }

    public ISelection parseSelection(String selectedMethod) {
        AccessPointType selection = null;
        if (this.root instanceof ITypedElement && this.root instanceof IExtensibleElement) {
            selection = this.parseSelection((ITypedElement)this.root, selectedMethod);
        }
        return selection == null ? null : new StructuredSelection(selection);
    }

    private AccessPointType parseSelection(ITypedElement accessPoint, String selectedMethod) {
        DataTypeType dataType;
        IAccessPathEditor editor;
        String[] splitted;
        IMetaType type = accessPoint.getMetaType();
        if (type instanceof DataTypeType && this.exists((splitted = (editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)(dataType = (DataTypeType)accessPoint.getMetaType()))).splitAccessPath(selectedMethod))[0])) {
            Object[] children = this.getChildren(accessPoint);
            int i = 0;
            while (i < children.length) {
                AccessPointType child = (AccessPointType)children[i];
                if (splitted[0].equals(child.getId())) {
                    return this.exists(splitted[1]) ? this.parseSelection((ITypedElement)child, splitted[1]) : child;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean exists(String string) {
        return string != null && string.length() > 0;
    }

    public MessagingAccessPathBrowserContentProvider(DirectionType direction) {
        super(direction);
    }

    public MessagingAccessPathBrowserContentProvider(DirectionType direction, String rootTypeName) {
        super(direction);
        this.rootTypeName = rootTypeName;
    }

    public String getRootTypeName() {
        return this.rootTypeName;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getChildren(parentElement, false, true);
    }

    private String getFullQualifiedName(DataTypeType dataType, String type, String className) {
        Class<?> clazz;
        block5: {
            IJavaProject jp = JavaCore.create((IProject)WorkspaceUtils.getProjectFromEObject((EObject)dataType));
            MTAClassLoader cl = new MTAClassLoader(jp);
            clazz = cl.loadClass(className);
            if (clazz != null) break block5;
            return null;
        }
        try {
            Field[] fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (type.equalsIgnoreCase(field.getType().getSimpleName())) {
                    return field.getType().getCanonicalName();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }
}

