/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.validation.ExtensionDescriptor;
import org.osgi.framework.Bundle;

public class EquinoxExtensionDescriptor
implements ExtensionDescriptor {
    private final IConfigurationElement template;

    public EquinoxExtensionDescriptor(IConfigurationElement template) {
        this.template = template;
    }

    public boolean isMatchingClass(EObject element, String classAttributeName) throws ClassNotFoundException {
        Bundle bundle;
        String objectClass = this.template.getAttribute(classAttributeName);
        if (StringUtils.isEmpty((String)objectClass)) {
            return true;
        }
        Class targetClass = null;
        String bundleId = null;
        if (this.template.getContributor() != null) {
            bundleId = this.template.getContributor().getName();
        }
        if (bundleId != null && (bundle = Platform.getBundle(bundleId)) != null && bundle.getState() == 32) {
            targetClass = bundle.loadClass(objectClass);
        }
        if (targetClass == null) {
            targetClass = Class.forName(objectClass);
        }
        return targetClass.isInstance(element);
    }

    public IConfigurationElement[] getFilters() {
        return this.template.getChildren("filter");
    }

    public Object createExecutableExtension() throws InstantiationException {
        try {
            return this.template.createExecutableExtension("class");
        }
        catch (CoreException ce) {
            throw new InstantiationException(ce.getMessage());
        }
    }
}

