/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.contextTypes;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class JFCValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        List result = CollectionUtils.newList();
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
        if (className == null) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_JFC_UnspecifiedClass, (Object)"carnot:engine:className"));
        } else {
            TypeFinder typeFinder = new TypeFinder((EObject)element);
            ModelType model = ModelUtils.findContainingModel((EObject)element);
            VariableContext variableContext = VariableContextHelper.getInstance().getContext(model);
            className = variableContext.replaceAllVariablesByDefaultValue(className);
            TypeInfo type = typeFinder.findType(className);
            if (type == null) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_JFC_CouldntFindClass, className), (Object)"carnot:engine:className"));
            } else {
                String methodName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
                if (methodName == null) {
                    result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_JFC_UnspecifiedCompletionMethod, (Object)"carnot:engine:methodName"));
                } else {
                    MethodInfo info = typeFinder.getMethod(type, methodName = variableContext.replaceAllVariablesByDefaultValue(methodName));
                    if (info == null) {
                        result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_JFC_CouldntFindCompletionMethod, methodName), (Object)"carnot:engine:methodName"));
                    } else if (!info.isAccessible()) {
                        result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_MethodNotVisible, methodName, type.getType().getElementName()), (Object)"carnot:engine:methodName"));
                    }
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

