/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.ios.core.xcode.XCodeBuild;
import org.eclipse.thym.ios.core.xcode.XCodeSDK;
import org.eclipse.thym.ui.launch.HybridProjectLaunchShortcut;
import org.osgi.framework.Version;

public class IOSLaunchShortcut
extends HybridProjectLaunchShortcut {
    protected boolean validateBuildToolsReady() throws CoreException {
        XCodeBuild xcode = new XCodeBuild();
        String version = xcode.version();
        if (version == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.ui", "Can not retrieve xcode version, is xcode properly installed?"));
        }
        try {
            Version minVersion = new Version("6.0.0");
            Version v = Version.parseVersion((String)version);
            if (v.compareTo(minVersion) < 0) {
                throw new CoreException((IStatus)new HybridMobileStatus(4, "org.eclipse.thym.ios.core", 300, NLS.bind((String)"Hybrid mobile projects require XCode version {0} or greater to build iOS applications", (Object)"6.0.0"), null));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        List sdks = xcode.showSdks();
        boolean iosSdkAvailable = false;
        for (XCodeSDK xcodeSDK : sdks) {
            if (!xcodeSDK.isIOS()) continue;
            iosSdkAvailable = true;
            break;
        }
        if (!iosSdkAvailable) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.ui", "No iOS SDKs are found. Please install an iOS SDK and try again."));
        }
        return true;
    }

    protected String getLaunchConfigurationTypeID() {
        return "org.eclipse.thym.ios.core.IOSSimulatorLaunchConfigType";
    }

    protected String getLaunchConfigurationNamePrefix(IProject project) {
        return String.valueOf(project.getName()) + " (iOS Simulator)";
    }
}

