/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.arraylist;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;

public class LazyArrayListStore<@NonNull E extends ISegment>
implements ISegmentStore<E> {
    private final Comparator<E> COMPARATOR = Ordering.from(SegmentComparators.INTERVAL_START_COMPARATOR).compound(SegmentComparators.INTERVAL_END_COMPARATOR);
    private final ReentrantLock fLock = new ReentrantLock(false);
    private final List<E> fStore = new ArrayList();
    private transient @Nullable Iterable<E> fLastSnapshot = null;
    private volatile boolean fDirty = false;

    public LazyArrayListStore() {
    }

    public LazyArrayListStore(Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof ISegment) {
                ISegment element = (ISegment)array[i];
                this.setDirtyIfNeeded(element);
                this.fStore.add(element);
            }
            ++i;
        }
        if (this.fDirty) {
            this.sortStore();
        }
    }

    private void setDirtyIfNeeded(@NonNull E value) {
        if (!this.fStore.isEmpty() && this.COMPARATOR.compare((ISegment)this.fStore.get(this.size() - 1), value) > 0) {
            this.fDirty = true;
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.fLock.lock();
        try {
            ImmutableList lastSnapshot;
            if (this.fDirty) {
                this.sortStore();
            }
            if ((lastSnapshot = this.fLastSnapshot) == null) {
                this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf(this.fStore);
            }
            Iterator iterator = (Iterator)NonNullUtils.checkNotNull(lastSnapshot.iterator());
            return iterator;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void sortStore() {
        this.fStore.sort(this.COMPARATOR);
        this.fDirty = false;
    }

    @Override
    public boolean add(@Nullable E val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot add null value");
        }
        this.fLock.lock();
        try {
            this.setDirtyIfNeeded(val);
            this.fStore.add(val);
            this.fLastSnapshot = null;
            return true;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public int size() {
        this.fLock.lock();
        try {
            int n = this.fStore.size();
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.isEmpty();
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean contains(@Nullable Object o) {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.contains(o);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.containsAll(c);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.fLock.lock();
        try {
            if (this.fDirty) {
                this.sortStore();
            }
            Object[] objectArray = this.fStore.toArray();
            return objectArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.fLock.lock();
        try {
            if (this.fDirty) {
                this.sortStore();
            }
            T[] TArray = this.fStore.toArray(a);
            return TArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.lock();
        try {
            boolean changed = false;
            for (ISegment elem : c) {
                if (!this.add((E)elem)) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.fLock.lock();
        try {
            this.fStore.clear();
            this.fLastSnapshot = null;
            this.fDirty = false;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public Iterable<E> getIntersectingElements(long start, long end) {
        this.fLock.lock();
        if (this.fDirty) {
            this.sortStore();
        }
        try {
            int index = Collections.binarySearch(this.fStore, new BasicSegment(end, Long.MAX_VALUE));
            index = index >= 0 ? index : -index - 1;
            Iterable iterable = this.fStore.subList(0, index).stream().filter(element -> start <= element.getEnd() && end >= element.getStart()).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void dispose() {
        this.fLock.lock();
        try {
            this.fStore.clear();
            this.fDirty = false;
        }
        finally {
            this.fLock.unlock();
        }
    }
}

