/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.esprima;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.runtime.ECMAException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.esprima.DOMASTConverter;

public class EsprimaParser {
    private static final String ESPRIMA_OPT_ATTACH_COMMENT = "attachComment";
    private static final String ESPRIMA_OPT_RANGE = "range";
    private static final String ESPRIMA_OPT_TOLERANT = "tolerant";
    private static final String ESPRIMA_OPT_SOURCE_TYPE = "sourceType";
    private static ScriptEngine engine;
    private static CompiledScript compiledEsprima;
    private Bindings bindings;
    private String rawContent;
    private IJavaScriptUnit unit;
    private boolean tolerant = Boolean.TRUE;
    private boolean range = Boolean.TRUE;
    private boolean errorReporting = Boolean.TRUE;
    private boolean includeJsdocs = Boolean.FALSE;
    private String sourceType;

    private EsprimaParser() {
        this.bindings = engine.createBindings();
        try {
            compiledEsprima.eval(this.bindings);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsprimaParser newParser() {
        ScriptEngineManager manager = new ScriptEngineManager();
        Class<EsprimaParser> clazz = EsprimaParser.class;
        synchronized (EsprimaParser.class) {
            if (engine == null) {
                engine = manager.getEngineByName("nashorn");
                Compilable compilable = (Compilable)((Object)engine);
                try {
                    InputStream in = EsprimaParser.class.getResourceAsStream("esprima.js");
                    if (in == null) {
                        throw new RuntimeException("Failed to load esprima.js file");
                    }
                    compiledEsprima = compilable.compile(new InputStreamReader(in));
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new EsprimaParser();
        }
    }

    public EsprimaParser setSource(String content) {
        this.unit = null;
        this.rawContent = content;
        return this;
    }

    public EsprimaParser setSource(IJavaScriptUnit content) {
        this.rawContent = null;
        this.unit = content;
        return this;
    }

    public JavaScriptUnit parse() {
        String content = this.rawContent;
        if (this.unit != null) {
            try {
                content = this.unit.getSource();
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        AST ast = AST.newAST(3);
        ast.setDefaultNodeFlag(2);
        JavaScriptUnit $ = ast.newJavaScriptUnit();
        try {
            ScriptObjectMirror jsObject = this.internalParse(content);
            this.translate(jsObject, $);
            this.buildLineEndTable($, content);
            if (this.errorReporting && this.tolerant) {
                this.reportErrors(jsObject, $);
            }
            if (this.includeJsdocs) {
                this.buildComments(jsObject, $, ast);
            }
            ast.setDefaultNodeFlag(0);
        }
        catch (ECMAException e) {
            if (!(e.getEcmaError() instanceof ScriptObjectMirror)) {
                e.printStackTrace();
            }
            $.setProblems(new DefaultProblem[]{this.createProblem((ScriptObjectMirror)e.getEcmaError())});
            $.setFlags(1);
        }
        return $;
    }

    public EsprimaParser noTolerantParsing() {
        this.tolerant = false;
        return this;
    }

    public EsprimaParser noRangeLocationInfo() {
        this.range = false;
        return this;
    }

    public EsprimaParser noErrorReporting() {
        this.errorReporting = false;
        return this;
    }

    public EsprimaParser includeComments() {
        this.includeJsdocs = true;
        return this;
    }

    public EsprimaParser setSourceType(String value) {
        this.sourceType = value;
        return this;
    }

    private JavaScriptUnit translate(ScriptObjectMirror jsObject, JavaScriptUnit jsunit) {
        return new DOMASTConverter(jsunit).convert(jsObject);
    }

    private ScriptObjectMirror internalParse(String content) {
        ScriptObjectMirror esprima = (ScriptObjectMirror)this.bindings.get("esprima");
        if (esprima == null) {
            throw new RuntimeException("Esprima parser was not loaded correctly");
        }
        return (ScriptObjectMirror)esprima.callMember("parse", new Object[]{content, this.getOptions()});
    }

    private HashMap<String, Object> getOptions() {
        HashMap<String, Object> $ = new HashMap<String, Object>();
        $.put(ESPRIMA_OPT_RANGE, this.range);
        $.put(ESPRIMA_OPT_TOLERANT, this.tolerant);
        $.put(ESPRIMA_OPT_ATTACH_COMMENT, this.includeJsdocs);
        if (this.sourceType != null) {
            $.put(ESPRIMA_OPT_SOURCE_TYPE, this.sourceType);
        }
        return $;
    }

    private void reportErrors(ScriptObjectMirror jsObject, JavaScriptUnit result) {
        ScriptObjectMirror errors = (ScriptObjectMirror)jsObject.getMember("errors");
        if (errors == null || errors.size() < 1) {
            return;
        }
        IProblem[] problems = new DefaultProblem[errors.size()];
        int i = 0;
        while (i < errors.size()) {
            problems[i] = this.createProblem((ScriptObjectMirror)errors.getSlot(i));
            ++i;
        }
        result.setFlags(1);
        result.setProblems(problems);
    }

    private DefaultProblem createProblem(ScriptObjectMirror error) {
        String description = (String)error.getMember("description");
        Number index = (Number)error.getMember("index");
        Number line = (Number)error.getMember("lineNumber");
        Number column = (Number)error.getMember("column");
        char[] fileName = null;
        if (this.unit != null) {
            CompilationUnit cu = (CompilationUnit)this.unit;
            fileName = cu.getFileName();
        }
        DefaultProblem result = new DefaultProblem(fileName, description, 0, null, 1, index.intValue(), -1, line.intValue(), column.intValue());
        return result;
    }

    private void buildComments(ScriptObjectMirror jsObject, JavaScriptUnit result, AST t) {
        ScriptObjectMirror comments = (ScriptObjectMirror)jsObject.getMember("comments");
        int commentSize = comments.size();
        Comment[] resultComments = new Comment[commentSize];
        int i = 0;
        while (i < commentSize) {
            ScriptObjectMirror obj = (ScriptObjectMirror)comments.getSlot(i);
            Comment newComment = EsprimaParser.createComment(obj, t);
            newComment.setAlternateRoot(result);
            resultComments[i] = newComment;
            ++i;
        }
        result.setCommentTable(resultComments);
    }

    static Comment createComment(ScriptObjectMirror m, AST t) {
        LineComment $;
        String type = (String)m.getMember("type");
        String value = (String)m.getMember("value");
        Comment comment = "Line".equals(type) ? t.newLineComment() : ($ = !value.startsWith("*") ? t.newBlockComment() : t.newJSdoc());
        if ($.isDocComment()) {
            ((JSdoc)((Object)$)).setComment("/*" + value + "*/");
        }
        ScriptObjectMirror r = (ScriptObjectMirror)m.getMember(ESPRIMA_OPT_RANGE);
        Number x = (Number)r.getSlot(0);
        Number y = (Number)r.getSlot(1);
        $.setSourceRange(x.intValue(), y.intValue() - x.intValue());
        return $;
    }

    private void buildLineEndTable(JavaScriptUnit jsunit, String content) {
        int[] lineEnds = new int[250];
        int linePtr = 0;
        int i = 0;
        int e = content.length();
        while (i < e) {
            if (content.charAt(i) == '\n' || content.charAt(i) == '\r') {
                int length;
                if (content.length() > i + 1 && content.charAt(i) == '\r' && content.charAt(i + 1) == '\n') {
                    ++i;
                }
                if (linePtr >= (length = lineEnds.length)) {
                    int[] nArray = lineEnds;
                    lineEnds = new int[length + 250];
                    System.arraycopy(nArray, 0, lineEnds, 0, length);
                }
                lineEnds[linePtr++] = i;
            }
            ++i;
        }
        int[] nArray = lineEnds;
        lineEnds = new int[linePtr];
        System.arraycopy(nArray, 0, lineEnds, 0, linePtr);
        jsunit.setLineEndTable(lineEnds);
    }
}

