/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.Locale;

public class DockerHost {
    public static final int DEFAULT_PORT = 2375;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_UNIX_ENDPOINT = "unix:///var/run/docker.sock";
    private final String host;
    private final URI uri;
    private final URI bindURI;
    private final String address;
    private final int port;
    private final String dockerCertPath;

    private DockerHost(String endpoint, String dockerCertPath) {
        if (endpoint.startsWith("unix://")) {
            this.port = 0;
            this.address = DEFAULT_HOST;
            this.host = endpoint;
            this.uri = URI.create(endpoint);
            this.bindURI = URI.create(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            HostAndPort hostAndPort = HostAndPort.fromString((String)stripped);
            String hostText = hostAndPort.getHostText();
            String scheme = Strings.isNullOrEmpty((String)dockerCertPath) ? "http" : "https";
            this.port = hostAndPort.getPortOrDefault(DockerHost.defaultPort());
            this.address = Strings.isNullOrEmpty((String)hostText) ? DEFAULT_HOST : hostText;
            this.host = this.address + ":" + this.port;
            this.uri = URI.create(scheme + "://" + this.address + ":" + this.port);
            this.bindURI = URI.create("tcp://" + this.address + ":" + this.port);
        }
        this.dockerCertPath = dockerCertPath;
    }

    public String host() {
        return this.host;
    }

    public URI uri() {
        return this.uri;
    }

    public URI bindURI() {
        return this.bindURI;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        return this.address;
    }

    public String dockerCertPath() {
        return this.dockerCertPath;
    }

    public static DockerHost fromEnv() {
        String defaultEndpoint = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).equals("linux") ? DEFAULT_UNIX_ENDPOINT : "localhost:" + DockerHost.defaultPort();
        String host = (String)Optional.fromNullable((Object)System.getenv("DOCKER_HOST")).or((Object)defaultEndpoint);
        String dockerCertPath = System.getenv("DOCKER_CERT_PATH");
        return new DockerHost(host, dockerCertPath);
    }

    public static DockerHost from(String endpoint, String dockerCertPath) {
        return new DockerHost(endpoint, dockerCertPath);
    }

    private static int defaultPort() {
        String port = System.getenv("DOCKER_PORT");
        if (port == null) {
            return 2375;
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return 2375;
        }
    }

    public String toString() {
        return this.host();
    }
}

