/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Date;

public class UnixTimestampDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = p.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            return UnixTimestampDeserializer.toDate(Long.parseLong(str));
        }
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return UnixTimestampDeserializer.toDate(p.getLongValue());
        }
        throw ctxt.wrongTokenException(p, JsonToken.VALUE_STRING, "Expected a string or numeric value");
    }

    private static Date toDate(long secondsSinceEpoch) {
        return new Date(secondsSinceEpoch * 1000L);
    }
}

