/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AuthRegistryConfig {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
    private final String repository;
    private final String username;
    private final String password;
    private final String auth;
    private final String email;
    private final String serverAddress;
    public static final AuthRegistryConfig EMPTY = new AuthRegistryConfig("", "", "", "", "", "");

    public AuthRegistryConfig(String repository, String username, String password, String auth, String email, String serverAddress) {
        this.repository = repository;
        this.username = username;
        this.password = password;
        this.auth = auth;
        this.email = email;
        this.serverAddress = serverAddress;
        this.properties.put("username", username);
        this.properties.put("password", password);
        this.properties.put("auth", auth);
        this.properties.put("email", email);
        this.properties.put("serveraddress", serverAddress);
        this.configs.put(repository, this.properties);
    }

    public AuthRegistryConfig(String repository, String username, String password, String email, String serverAddress) {
        this(repository, username, password, "", email, serverAddress);
    }

    @JsonAnyGetter
    public Map<String, Map<String, String>> getConfigs() {
        return this.configs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthRegistryConfig config = (AuthRegistryConfig)o;
        if (this.repository != null ? !this.repository.equals(config.repository) : config.repository != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(config.username) : config.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(config.password) : config.password != null) {
            return false;
        }
        if (this.auth != null ? !this.auth.equals(config.auth) : config.auth != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(config.email) : config.email != null) {
            return false;
        }
        return !(this.serverAddress != null ? !this.serverAddress.equals(config.serverAddress) : config.serverAddress != null);
    }

    public int hashCode() {
        return Objects.hash(this.repository, this.username, this.password, this.auth, this.email, this.serverAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("repository", (Object)this.repository).add("username", (Object)this.username).add("password", (Object)this.password).add("auth", (Object)this.auth).add("email", (Object)this.email).add("serverAddress", (Object)this.serverAddress).toString();
    }
}

