/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;

public abstract class AbstractService
implements IService {
    @Override
    public boolean isEqualParameterTypes(IReadOnlyQueryEnvironment queryEnvironment, IService service) {
        List<IType> paramTypes1 = this.getParameterTypes(queryEnvironment);
        List<IType> paramTypes2 = service.getParameterTypes(queryEnvironment);
        boolean result = paramTypes1.size() == paramTypes2.size();
        Iterator<IType> it1 = paramTypes1.iterator();
        Iterator<IType> it2 = paramTypes2.iterator();
        while (result && it1.hasNext()) {
            IType paramType1 = it1.next();
            IType paramType2 = it2.next();
            if (paramType2.equals(paramType1)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean isLowerOrEqualParameterTypes(IReadOnlyQueryEnvironment queryEnvironment, IService service) {
        List<IType> paramTypes1 = this.getParameterTypes(queryEnvironment);
        List<IType> paramTypes2 = service.getParameterTypes(queryEnvironment);
        boolean result = paramTypes1.size() == paramTypes2.size();
        Iterator<IType> it1 = paramTypes1.iterator();
        Iterator<IType> it2 = paramTypes2.iterator();
        while (result && it1.hasNext()) {
            IType paramType1 = it1.next();
            IType paramType2 = it2.next();
            if (paramType2.isAssignableFrom(paramType1)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(IReadOnlyQueryEnvironment queryEnvironment, IType[] argumentTypes) {
        assert (this.getNumberOfParameters() == argumentTypes.length);
        boolean result = true;
        List<IType> parameterTypes = this.getParameterTypes(queryEnvironment);
        int i = 0;
        while (i < parameterTypes.size() && result) {
            if (argumentTypes[i].getType() != null && !parameterTypes.get(i).isAssignableFrom(argumentTypes[i])) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            result.addAll((Collection<IType>)entry.getValue());
        }
        return result;
    }

    @Override
    public Object invoke(Object ... arguments) throws AcceleoQueryEvaluationException {
        Object result;
        try {
            result = this.internalInvoke(arguments);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = cause != null ? cause.getMessage() : "";
            throw new AcceleoQueryEvaluationException(String.valueOf(this.getShortSignature()) + " with arguments " + Arrays.deepToString(arguments) + " failed:\n\t" + message, cause);
        }
        return result;
    }

    protected abstract Object internalInvoke(Object[] var1) throws Exception;

    protected String serviceShortSignature(Object[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append('(');
        boolean first = true;
        Object[] objectArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object argType = objectArray[n2];
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            if (argType instanceof Class) {
                builder.append(((Class)argType).getCanonicalName());
            } else if (argType instanceof EClass) {
                builder.append("EClass=" + ((EClass)argType).getName());
            } else if (argType == null) {
                builder.append("Object=null");
            } else {
                builder.append("Object=" + argType.toString());
            }
            ++n2;
        }
        return builder.append(')').toString();
    }

    public String toString() {
        return this.getLongSignature();
    }

    @Override
    public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        return Collections.emptyList();
    }
}

